# Character Classes

## Barbarian

### Class Features

As a barbarian, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d12 per barbarian level

**Hit Points at 1st Level:** 12 + your Constitution modifier

**Hit Points at Higher Levels:** 1d12 (or 7) + your Constitution modifier per barbarian level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, shields

**Weapons:** Simple weapons, martial weapons

**Tools:** None

**Saving Throws:** Strength, Constitution

**Skills:** Choose two from Animal Handling, Athletics, Intimidation, Nature, Perception, and Survival

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a greataxe or (*b*) any martial melee weapon
- (*a*) two handaxes or (*b*) any simple weapon
- An explorer's pack and four javelins

**Table- The Barbarian**

| Level | Proficiency Bonus | Features                      | Rages     | Rage Damage |
|-------|-------------------|-------------------------------|-----------|-------------|
| 1st   | +2                | Rage, Unarmored Defense       | 2         | +2          |
| 2nd   | +2                | Reckless Attack, Danger Sense | 2         | +2          |
| 3rd   | +2                | Primal Path                   | 3         | +2          |
| 4th   | +2                | Ability Score Improvement     | 3         | +2          |
| 5th   | +3                | Extra Attack, Fast Movement   | 3         | +2          |
| 6th   | +3                | Path feature                  | 4         | +2          |
| 7th   | +3                | Feral Instinct                | 4         | +2          |
| 8th   | +3                | Ability Score Improvement     | 4         | +2          |
| 9th   | +4                | Brutal Critical (1 die)       | 4         | +3          |
| 10th  | +4                | Path feature                  | 4         | +3          |
| 11th  | +4                | Relentless                    | 4         | +3          |
| 12th  | +4                | Ability Score Improvement     | 5         | +3          |
| 13th  | +5                | Brutal Critical (2 dice)      | 5         | +3          |
| 14th  | +5                | Path feature                  | 5         | +3          |
| 15th  | +5                | Persistent Rage               | 5         | +3          |
| 16th  | +5                | Ability Score Improvement     | 5         | +4          |
| 17th  | +6                | Brutal Critical (3 dice)      | 6         | +4          |
| 18th  | +6                | Indomitable Might             | 6         | +4          |
| 19th  | +6                | Ability Score Improvement     | 6         | +4          |
| 20th  | +6                | Primal Champion               | Unlimited | +4          |
|       |                   |                               |           |             |

### Rage

In battle, you fight with primal ferocity. On your turn, you can enter a rage as a bonus action.

While raging, you gain the following benefits if you aren't wearing heavy armor:

- You have advantage on Strength checks and Strength saving throws.
- When you make a melee weapon attack using Strength, you gain a bonus to the damage roll that increases as you gain levels as a barbarian, as shown in the Rage Damage column of the Barbarian table.
- You have resistance to bludgeoning, piercing, and slashing damage.

If you are able to cast spells, you can't cast them or concentrate on them while raging.

Your rage lasts for 1 minute. It ends early if you are knocked unconscious or if your turn ends and you haven't attacked a hostile creature since your last turn or taken damage since then. You can also end your rage on your turn as a bonus action.

Once you have raged the number of times shown for your barbarian level in the Rages column of the Barbarian table, you must finish a long rest before you can rage again.

### Unarmored Defense

While you are not wearing any armor, your Armor Class equals 10 + your Dexterity modifier + your Constitution modifier. You can use a shield and still gain this benefit.

### Reckless Attack

Starting at 2nd level, you can throw aside all concern for defense to attack with fierce desperation. When you make your first attack on your turn, you can decide to attack recklessly. Doing so gives you advantage on melee weapon attack rolls using Strength during this turn, but attack rolls against you have advantage until your next turn.

### Danger Sense

At 2nd level, you gain an uncanny sense of when things nearby aren't as they should be, giving you an edge when you dodge away from danger.

You have advantage on Dexterity saving throws against effects that you can see, such as traps and spells. To gain this benefit, you can't be blinded, deafened, or incapacitated.

### Primal Path

At 3rd level, you choose a path that shapes the nature of your rage. Choose the Path of the Berserker or the Path of the Totem Warrior, both detailed at the end of the class description. Your choice grants you features at 3rd level and again at 6th, 10th, and 14th levels.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Extra Attack

Beginning at 5th level, you can attack twice, instead of once, whenever you take the Attack action on your turn.

### Fast Movement

Starting at 5th level, your speed increases by 10 feet while you aren't wearing heavy armor.

### Feral Instinct

By 7th level, your instincts are so honed that you have advantage on initiative rolls.

Additionally, if you are surprised at the beginning of combat and aren't incapacitated, you can act normally on your first turn, but only if you enter your rage before doing anything else on that turn.

### Brutal Critical

Beginning at 9th level, you can roll one additional weapon damage die when determining the extra damage for a critical hit with a melee attack.

This increases to two additional dice at 13th level and three additional dice at 17th level.

### Relentless Rage

Starting at 11th level, your rage can keep you fighting despite grievous wounds. If you drop to 0 hit points while you're raging and don't die outright, you can make a DC 10 Constitution saving throw. If you succeed, you drop to 1 hit point instead.

Each time you use this feature after the first, the DC increases by 5. When you finish a short or long rest, the DC resets to 10.

### Persistent Rage

Beginning at 15th level, your rage is so fierce that it ends early only if you fall unconscious or if you choose to end it.

### Indomitable Might

Beginning at 18th level, if your total for a Strength check is less than your Strength score, you can use that score in place of the total.

### Primal Champion

At 20th level, you embody the power of the wilds. Your Strength and Constitution scores increase by 4. Your maximum for those scores is now 24.

## Barbarian Paths

### Path of the Berserker

For some barbarians, rage is a means to an end- that end being violence. The Path of the Berserker is a path of untrammeled fury, slick with blood. As you enter the berserker's rage, you thrill in the chaos of battle, heedless of your own health or well-being.

#### Frenzy

Starting when you choose this path at 3rd level, you can go into a frenzy when you rage. If you do so, for the duration of your rage you can make a single melee weapon attack as a bonus action on each of your turns after this one. When your rage ends, you suffer one level of exhaustion (as described in appendix A).

#### Mindless Rage

Beginning at 6th level, you can't be charmed or frightened while raging. If you are charmed or frightened when you enter your rage, the effect is suspended for the duration of the rage.

#### Intimidating Presence

Beginning at 10th level, you can use your action to frighten someone with your menacing presence. When you do so, choose one creature that you can see within 30 feet of you. If the creature can see or hear you, it must succeed on a Wisdom saving throw (DC equal to 8 + your proficiency bonus + your Charisma modifier) or be frightened of you until the end of your next turn. On subsequent turns, you can use your action to extend the duration of this effect on the frightened creature until the end of your next turn. This effect ends if the creature ends its turn out of line of sight or more than 60 feet away from you.

If the creature succeeds on its saving throw, you can't use this feature on that creature again for 24 hours.

#### Retaliation

Starting at 14th level, when you take damage from a creature that is within 5 feet of you, you can use your reaction to make a melee weapon attack against that creature.

## Bard

### Class Features

As a bard, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d8 per bard level

**Hit Points at 1st Level:** 8 + your Constitution modifier

**Hit Points at Higher Levels:** 1d8 (or 5) + your Constitution modifier per bard level after 1st

#### Proficiencies

**Armor:** Light armor

**Weapons:** Simple weapons, hand crossbows, longswords, rapiers, shortswords

**Tools:** Three musical instruments of your choice

**Saving Throws:** Dexterity, Charisma

**Skills:** Choose any three

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a rapier, (*b*) a longsword, or (*c*) any simple weapon
- (*a*) a diplomat's pack or (*b*) an entertainer's pack
- (*a*) a lute or (*b*) any other musical instrument
- Leather armor and a dagger

**Table- The Bard**

| Level | Proficiency Bonus | Features                                             | Cantrips Known | Spells Known | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
|-------|-------------------|------------------------------------------------------|----------------|--------------|-----|-----|-----|-----|-----|-----|-----|-----|-----|
| 1st   | +2                | Spellcasting, Bardic Inspiration (d6)                | 2              | 4            | 2   | -   | -   | -   | -   | -   | -   | -   | -   |
| 2nd   | +2                | Jack of All Trades, Song of Rest (d6)                | 2              | 5            | 3   | -   | -   | -   | -   | -   | -   | -   | -   |
| 3rd   | +2                | Bard College, Expertise                              | 2              | 6            | 4   | 2   | -   | -   | -   | -   | -   | -   | -   |
| 4th   | +2                | Ability Score Improvement                            | 3              | 7            | 4   | 3   | -   | -   | -   | -   | -   | -   | -   |
| 5th   | +3                | Bardic Inspiration (d8), Font of Inspiration         | 3              | 8            | 4   | 3   | 2   | -   | -   | -   | -   | -   | -   |
| 6th   | +3                | Countercharm, Bard College Feature                   | 3              | 9            | 4   | 3   | 3   | -   | -   | -   | -   | -   | -   |
| 7th   | +3                | -                                                    | 3              | 10           | 4   | 3   | 3   | 1   | -   | -   | -   | -   | -   |
| 8th   | +3                | Ability Score Improvement                            | 3              | 11           | 4   | 3   | 3   | 2   | -   | -   | -   | -   | -   |
| 9th   | +4                | Song of Rest (d8)                                    | 3              | 12           | 4   | 3   | 3   | 3   | 1   | -   | -   | -   | -   |
| 10th  | +4                | Bardic Inspiration (d10), Expertise, Magical Secrets | 4              | 14           | 4   | 3   | 3   | 3   | 2   | -   | -   | -   | -   |
| 11th  | +4                | -                                                    | 4              | 15           | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 12th  | +4                | Ability Score Improvement                            | 4              | 15           | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 13th  | +5                | Song of Rest (d10)                                   | 4              | 16           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 14th  | +5                | Magical Secrets, Bard College Feature                | 4              | 18           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 15th  | +5                | Bardic Inspiration (d12)                             | 4              | 19           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 16th  | +5                | Ability Score Improvement                            | 4              | 19           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 17th  | +6                | Song of Rest (d12)                                   | 4              | 20           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | 1   |
| 18th  | +6                | Magical Secrets                                      | 4              | 22           | 4   | 3   | 3   | 3   | 3   | 1   | 1   | 1   | 1   |
| 19th  | +6                | Ability Score Improvement                            | 4              | 22           | 4   | 3   | 3   | 3   | 3   | 2   | 1   | 1   | 1   |
| 20th  | +6                | Superior Inspiration                                 | 4              | 22           | 4   | 3   | 3   | 3   | 3   | 2   | 2   | 1   | 1   |
|       |                   |                                                      |                |              |     |     |     |     |     |     |     |     |     |

### Spellcasting

You have learned to untangle and reshape the fabric of reality in harmony with your wishes and music.

Your spells are part of your vast repertoire, magic that you can tune to different situations.

#### Cantrips

You know two cantrips of your choice from the bard spell list. You learn additional bard cantrips of your choice at higher levels, as shown in the Cantrips Known column of the Bard table.

#### Spell Slots

The Bard table shows how many spell slots you have to cast your bard spells of 1st level and higher. To cast one of these spells, you must expend a slot of the spell's level or higher. You regain all expended spell slots when you finish a long rest.

For example, if you know the 1st-level spell *cure wounds* and have a 1st-level and a 2nd-level spell slot available, you can cast *cure wounds* using either slot.

#### Spells Known of 1st Level and Higher

You know four 1st-level spells of your choice from the bard spell list.

The Spells Known column of the Bard table shows when you learn more bard spells of your choice. Each of these spells must be of a level for which you have spell slots, as shown on the table. For instance, when you reach 3rd level in this class, you can learn one new spell of 1st or 2nd level.

Additionally, when you gain a level in this class, you can choose one of the bard spells you know and replace it with another spell from the bard spell list, which also must be of a level for which you have spell slots.

#### Spellcasting Ability

Charisma is your spellcasting ability for your bard spells. Your magic comes from the heart and soul you pour into the performance of your music or oration. You use your Charisma whenever a spell refers to your spellcasting ability. In addition, you use your Charisma modifier when setting the saving throw DC for a bard spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Charisma modifier

**Spell attack modifier** = your proficiency bonus + your Charisma modifier

#### Ritual Casting

You can cast any bard spell you know as a ritual if that spell has the ritual tag.

#### Spellcasting Focus

You can use a musical instrument as a spellcasting focus for your bard spells.

### Bardic Inspiration

You can inspire others through stirring words or music. To do so, you use a bonus action on your turn to choose one creature other than yourself within 60 feet of you who can hear you. That creature gains one Bardic Inspiration die, a d6.

Once within the next 10 minutes, the creature can roll the die and add the number rolled to one ability check, attack roll, or saving throw it makes. The creature can wait until after it rolls the d20 before deciding to use the Bardic Inspiration die, but must decide before the GM says whether the roll succeeds or fails. Once the Bardic Inspiration die is rolled, it is lost. A creature can have only one Bardic Inspiration die at a time.

You can use this feature a number of times equal to your Charisma modifier (a minimum of once). You regain any expended uses when you finish a long rest.

Your Bardic Inspiration die changes when you reach certain levels in this class. The die becomes a d8 at 5th level, a d10 at 10th level, and a d12 at 15th level.

### Jack of All Trades

Starting at 2nd level, you can add half your proficiency bonus, rounded down, to any ability check you make that doesn't already include your proficiency bonus.

### Song of Rest

Beginning at 2nd level, you can use soothing music or oration to help revitalize your wounded allies during a short rest. If you or any friendly creatures who can hear your performance regain hit points at the end of the short rest by spending one or more Hit Dice, each of those creatures regains an extra 1d6 hit points.

The extra hit points increase when you reach certain levels in this class: to 1d8 at 9th level, to 1d10 at 13th level, and to 1d12 at 17th level.

### Bard College

At 3rd level, you delve into the advanced techniques of a bard college of your choice: the College of Lore or the College of Valor, both detailed at the end of the class description. Your choice grants you features at 3rd level and again at 6th and 14th level.

### Expertise

At 3rd level, choose two of your skill proficiencies. Your proficiency bonus is doubled for any ability check you make that uses either of the chosen proficiencies.

At 10th level, you can choose another two skill proficiencies to gain this benefit.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Font of Inspiration

Beginning when you reach 5th level, you regain all of your expended uses of Bardic Inspiration when you finish a short or long rest.

### Countercharm

At 6th level, you gain the ability to use musical notes or words of power to disrupt mind-influencing effects. As an action, you can start a performance that lasts until the end of your next turn. During that time, you and any friendly creatures within 30 feet of you have advantage on saving throws against being frightened or charmed. A creature must be able to hear you to gain this benefit. The performance ends early if you are incapacitated or silenced or if you voluntarily end it (no action required).

### Magical Secrets

By 10th level, you have plundered magical knowledge from a wide spectrum of disciplines. Choose two spells from any classes, including this one. A spell you choose must be of a level you can cast, as shown on the Bard table, or a cantrip.

The chosen spells count as bard spells for you and are included in the number in the Spells Known column of the Bard table.

You learn two additional spells from any classes at 14th level and again at 18th level.

### Superior Inspiration

At 20th level, when you roll initiative and have no uses of Bardic Inspiration left, you regain one use.

## Bard Colleges

### College of Lore

Bards of the College of Lore know something about most things, collecting bits of knowledge from sources as diverse as scholarly tomes and peasant tales. Whether singing folk ballads in taverns or elaborate compositions in royal courts, these bards use their gifts to hold audiences spellbound. When the applause dies down, the audience members might find themselves questioning everything they held to be true, from their faith in the priesthood of the local temple to their loyalty to the king.

The loyalty of these bards lies in the pursuit of beauty and truth, not in fealty to a monarch or following the tenets of a deity. A noble who keeps such a bard as a herald or advisor knows that the bard would rather be honest than politic.

The college's members gather in libraries and sometimes in actual colleges, complete with classrooms and dormitories, to share their lore with one another. They also meet at festivals or affairs of state, where they can expose corruption, unravel lies, and poke fun at self-important figures of authority.

#### Bonus Proficiencies

When you join the College of Lore at 3rd level, you gain proficiency with three skills of your choice.

#### Cutting Words

Also at 3rd level, you learn how to use your wit to distract, confuse, and otherwise sap the confidence and competence of others. When a creature that you can see within 60 feet of you makes an attack roll, an ability check, or a damage roll, you can use your reaction to expend one of your uses of Bardic Inspiration, rolling a Bardic Inspiration die and subtracting the number rolled from the creature's roll. You can choose to use this feature after the creature makes its roll, but before the GM determines whether the attack roll or ability check succeeds or fails, or before the creature deals its damage. The creature is immune if it can't hear you or if it's immune to being charmed.

#### Additional Magical Secrets

At 6th level, you learn two spells of your choice from any class. A spell you choose must be of a level you can cast, as shown on the Bard table, or a cantrip. The chosen spells count as bard spells for you but don't count against the number of bard spells you know.

#### Peerless Skill

Starting at 14th level, when you make an ability check, you can expend one use of Bardic Inspiration. Roll a Bardic Inspiration die and add the number rolled to your ability check. You can choose to do so after you roll the die for the ability check, but before the GM tells you whether you succeed or fail.

## Cleric

### Class Features

As a cleric, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d8 per cleric level

**Hit Points at 1st Level:** 8 + your Constitution modifier

**Hit Points at Higher Levels:** 1d8 (or 5) + your Constitution modifier per cleric level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, shields

**Weapons:** Simple weapons

**Tools:** None

**Saving Throws:** Wisdom, Charisma

**Skills:** Choose two from History, Insight, Medicine, Persuasion, and Religion

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a mace or (*b*) a warhammer (if proficient)
- (*a*) scale mail, (*b*) leather armor, or (*c*) chain mail (if proficient)
- (*a*) a light crossbow and 20 bolts or (*b*) any simple weapon
- (*a*) a priest's pack or (*b*) an explorer's pack
- A shield and a holy symbol

**Table- The Cleric**

| Level | Proficiency Bonus | Features                                                                | Cantrips Known | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
|-------|-------------------|-------------------------------------------------------------------------|----------------|-----|-----|-----|-----|-----|-----|-----|-----|-----|
| 1st   | +2                | Spellcasting, Divine Domain                                             | 3              | 2   | -   | -   | -   | -   | -   | -   | -   | -   |
| 2nd   | +2                | Channel Divinity (1/rest), Divine Domain Feature                        | 3              | 3   | -   | -   | -   | -   | -   | -   | -   | -   |
| 3rd   | +2                | -                                                                       | 3              | 4   | 2   | -   | -   | -   | -   | -   | -   | -   |
| 4th   | +2                | Ability Score Improvement                                               | 4              | 4   | 3   | -   | -   | -   | -   | -   | -   | -   |
| 5th   | +3                | Destroy Undead (CR 1/2)                                                 | 4              | 4   | 3   | 2   | -   | -   | -   | -   | -   | -   |
| 6th   | +3                | Channel Divinity (2/rest), Divine Domain Feature                        | 4              | 4   | 3   | 3   | -   | -   | -   | -   | -   | -   |
| 7th   | +3                | -                                                                       | 4              | 4   | 3   | 3   | 1   | -   | -   | -   | -   | -   |
| 8th   | +3                | Ability Score Improvement, Destroy Undead (CR 1), Divine Domain Feature | 4              | 4   | 3   | 3   | 2   | -   | -   | -   | -   | -   |
| 9th   | +4                | -                                                                       | 4              | 4   | 3   | 3   | 3   | 1   | -   | -   | -   | -   |
| 10th  | +4                | Divine Intervention                                                     | 5              | 4   | 3   | 3   | 3   | 2   | -   | -   | -   | -   |
| 11th  | +4                | Destroy Undead (CR 2)                                                   | 5              | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 12th  | +4                | Ability Score Improvement                                               | 5              | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 13th  | +5                | -                                                                       | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 14th  | +5                | Destroy Undead (CR 3)                                                   | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 15th  | +5                | -                                                                       | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 16th  | +5                | Ability Score Improvement                                               | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 17th  | +6                | Destroy Undead (CR 4), Divine Domain Feature                            | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | 1   |
| 18th  | +6                | Channel Divinity (3/rest)                                               | 5              | 4   | 3   | 3   | 3   | 3   | 1   | 1   | 1   | 1   |
| 19th  | +6                | Ability Score Improvement                                               | 5              | 4   | 3   | 3   | 3   | 3   | 2   | 1   | 1   | 1   |
| 20th  | +6                | Divine Intervention improvement                                         | 5              | 4   | 3   | 3   | 3   | 3   | 2   | 2   | 1   | 1   |
|       |                   |                                                                         |                |     |     |     |     |     |     |     |     |     |

### Spellcasting

As a conduit for divine power, you can cast cleric spells.

#### Cantrips

At 1st level, you know three cantrips of your choice from the cleric spell list. You learn additional cleric cantrips of your choice at higher levels, as shown in the Cantrips Known column of the Cleric table.

#### Preparing and Casting Spells

The Cleric table shows how many spell slots you have to cast your cleric spells of 1st level and higher. To cast one of these spells, you must expend a slot of the spell's level or higher. You regain all expended spell slots when you finish a long rest.

You prepare the list of cleric spells that are available for you to cast, choosing from the cleric spell list. When you do so, choose a number of cleric spells equal to your Wisdom modifier + your cleric level (minimum of one spell). The spells must be of a level for which you have spell slots.

For example, if you are a 3rd-level cleric, you have four 1st-level and two 2nd-level spell slots. With a Wisdom of 16, your list of prepared spells can include six spells of 1st or 2nd level, in any combination. If you prepare the 1st-level spell *cure wounds*, you can cast it using a 1st-level or 2nd-level slot. Casting the spell doesn't remove it from your list of prepared spells.

You can change your list of prepared spells when you finish a long rest. Preparing a new list of cleric spells requires time spent in prayer and meditation: at least 1 minute per spell level for each spell on your list.

#### Spellcasting Ability

Wisdom is your spellcasting ability for your cleric spells. The power of your spells comes from your devotion to your deity. You use your Wisdom whenever a cleric spell refers to your spellcasting ability. In addition, you use your Wisdom modifier when setting the saving throw DC for a cleric spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Wisdom modifier

**Spell attack modifier** = your proficiency bonus + your Wisdom modifier

#### Ritual Casting

You can cast a cleric spell as a ritual if that spell has the ritual tag and you have the spell prepared.

#### Spellcasting Focus

You can use a holy symbol as a spellcasting focus for your cleric spells.

### Divine Domain

Choose one domain related to your deity: Knowledge, Life, Light, Nature, Tempest, Trickery, or War. Each domain is detailed at the end of the class description, and each one provides examples of gods associated with it. Your choice grants you domain spells and other features when you choose it at 1st level. It also grants you additional ways to use Channel Divinity when you gain that feature at 2nd level, and additional benefits at 6th, 8th, and 17th levels.

#### Domain Spells

Each domain has a list of spells - its domain spells - that you gain at the cleric levels noted in the domain description. Once you gain a domain spell, you always have it prepared, and it doesn't count against the number of spells you can prepare each day.

If you have a domain spell that doesn't appear on the cleric spell list, the spell is nonetheless a cleric spell for you.

### Channel Divinity

At 2nd level, you gain the ability to channel divine energy directly from your deity, using that energy to fuel magical effects. You start with two such effects: Turn Undead and an effect determined by your domain. Some domains grant you additional effects as you advance in levels, as noted in the domain description.

When you use your Channel Divinity, you choose which effect to create. You must then finish a short or long rest to use your Channel Divinity again.

Some Channel Divinity effects require saving throws. When you use such an effect from this class, the DC equals your cleric spell save DC.

Beginning at 6th level, you can use your Channel Divinity twice between rests, and beginning at 18th level, you can use it three times between rests. When you finish a short or long rest, you regain your expended uses.

#### Channel Divinity: Turn Undead

As an action, you present your holy symbol and speak a prayer censuring the undead. Each undead that can see or hear you within 30 feet of you must make a Wisdom saving throw. If the creature fails its saving throw, it is turned for 1 minute or until it takes any damage.

A turned creature must spend its turns trying to move as far away from you as it can, and it can't willingly move to a space within 30 feet of you. It also can't take reactions. For its action, it can use only the Dash action or try to escape from an effect that prevents it from moving. If there's nowhere to move, the creature can use the Dodge action.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Destroy Undead

Starting at 5th level, when an undead fails its saving throw against your Turn Undead feature, the creature is instantly destroyed if its challenge rating is at or below a certain threshold, as shown in the Destroy Undead table.

**Table- Destroy Undead**

| Cleric Level | Destroys Undead of CR ... |
|--------------|---------------------------|
| 5th          | 1/2 or lower              |
| 8th          | 1 or lower                |
| 11th         | 2 or lower                |
| 14th         | 3 or lower                |
| 17th         | 4 or lower                |
|              |                           |

### Divine Intervention

Beginning at 10th level, you can call on your deity to intervene on your behalf when your need is great.

Imploring your deity's aid requires you to use your action. Describe the assistance you seek, and roll percentile dice. If you roll a number equal to or lower than your cleric level, your deity intervenes. The GM chooses the nature of the intervention; the effect of any cleric spell or cleric domain spell would be appropriate.

If your deity intervenes, you can't use this feature again for 7 days. Otherwise, you can use it again after you finish a long rest.

At 20th level, your call for intervention succeeds automatically, no roll required.

## Cleric Domains

### Life Domain

The Life domain focuses on the vibrant positive energy-one of the fundamental forces of the universe-that sustains all life. The gods of life promote vitality and health through healing the sick and wounded, caring for those in need, and driving away the forces of death and undeath. Almost any non-evil deity can claim influence over this domain, particularly agricultural deities (such as Chauntea, Arawai, and Demeter), sun gods (such as Lathander, Pelor, and Re-Horakhty), gods of healing or endurance (such as Ilmater, Mishakal, Apollo, and Diancecht), and gods of home and community (such as Hestia, Hathor, and Boldrei).

**Table- Life Domain Spells**

| Cleric Level | Spells                               |
|--------------|--------------------------------------|
| 1st          | bless, cure wounds                   |
| 3rd          | lesser restoration, spiritual weapon |
| 5th          | beacon of hope, revivify             |
| 7th          | death ward, guardian of faith        |
| 9th          | mass cure wounds, raise dead         |
|              |                                      |

#### Bonus Proficiency

When you choose this domain at 1st level, you gain proficiency with heavy armor.

#### Disciple of Life

Also starting at 1st level, your healing spells are more effective. Whenever you use a spell of 1st level or higher to restore hit points to a creature, the creature regains additional hit points equal to 2 + the spell's level.

#### Channel Divinity: Preserve Life

Starting at 2nd level, you can use your Channel Divinity to heal the badly injured.

As an action, you present your holy symbol and evoke healing energy that can restore a number of hit points equal to five times your cleric level. Choose any creatures within 30 feet of you, and divide those hit points among them. This feature can restore a creature to no more than half of its hit point maximum. You can't use this feature on an undead or a construct.

#### Blessed Healer

Beginning at 6th level, the healing spells you cast on others heal you as well. When you cast a spell of 1st level or higher that restores hit points to a creature other than you, you regain hit points equal to 2 + the spell's level.

#### Divine Strike

At 8th level, you gain the ability to infuse your weapon strikes with divine energy. Once on each of your turns when you hit a creature with a weapon attack, you can cause the attack to deal an extra 1d8 radiant damage to the target. When you reach 14th level, the extra damage increases to 2d8.

#### Supreme Healing

Starting at 17th level, when you would normally roll one or more dice to restore hit points with a spell, you instead use the highest number possible for each die. For example, instead of restoring 2d6 hit points to a creature, you restore 12.

## Druid

### Class Features

As a druid, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d8 per druid level

**Hit Points at 1st Level:** 8 + your Constitution modifier

**Hit Points at Higher Levels:** 1d8 (or 5) + your Constitution modifier per druid level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, shields (druids will not wear armor or use shields made of metal)

**Weapons:** Clubs, daggers, darts, javelins, maces, quarterstaffs, scimitars, sickles, slings, spears

**Tools:** Herbalism kit

**Saving Throws:** Intelligence, Wisdom

**Skills:** Choose two from Arcana, Animal Handling, Insight, Medicine, Nature, Perception, Religion, and Survival

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a wooden shield or (*b*) any simple weapon
- (*a*) a scimitar or (*b*) any simple melee weapon
- Leather armor, an explorer's pack, and a druidic focus

**Table- The Druid**

| Level | Proficiency Bonus | Features                                          | Cantrips Known | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
|-------|-------------------|---------------------------------------------------|----------------|-----|-----|-----|-----|-----|-----|-----|-----|-----|
| 1st   | +2                | Druidic, Spellcasting                             | 2              | 2   | -   | -   | -   | -   | -   | -   | -   | -   |
| 2nd   | +2                | Wild Shape, Druid Circle                          | 2              | 3   | -   | -   | -   | -   | -   | -   | -   | -   |
| 3rd   | +2                | -                                                 | 2              | 4   | 2   | -   | -   | -   | -   | -   | -   | -   |
| 4th   | +2                | Wild Shape Improvement, Ability Score Improvement | 3              | 4   | 3   | -   | -   | -   | -   | -   | -   | -   |
| 5th   | +3                | -                                                 | 3              | 4   | 3   | 2   | -   | -   | -   | -   | -   | -   |
| 6th   | +3                | Druid Circle feature                              | 3              | 4   | 3   | 3   | -   | -   | -   | -   | -   | -   |
| 7th   | +3                | -                                                 | 3              | 4   | 3   | 3   | 1   | -   | -   | -   | -   | -   |
| 8th   | +3                | Wild Shape Improvement, Ability Score Improvement | 3              | 4   | 3   | 3   | 2   | -   | -   | -   | -   | -   |
| 9th   | +4                | -                                                 | 3              | 4   | 3   | 3   | 3   | 1   | -   | -   | -   | -   |
| 10th  | +4                | Druid Circle feature                              | 4              | 4   | 3   | 3   | 3   | 2   | -   | -   | -   | -   |
| 11th  | +4                | -                                                 | 4              | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 12th  | +4                | Ability Score Improvement                         | 4              | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 13th  | +5                | -                                                 | 4              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 14th  | +5                | Druid Circle feature                              | 4              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 15th  | +5                | -                                                 | 4              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 16th  | +5                | Ability Score Improvement                         | 4              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 17th  | +6                | -                                                 | 4              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | 1   |
| 18th  | +6                | Timeless Body, Beast Spells                       | 4              | 4   | 3   | 3   | 3   | 3   | 1   | 1   | 1   | 1   |
| 19th  | +6                | Ability Score Improvement                         | 4              | 4   | 3   | 3   | 3   | 3   | 2   | 1   | 1   | 1   |
| 20th  | +6                | Archdruid                                         | 4              | 4   | 3   | 3   | 3   | 3   | 2   | 2   | 1   | 1   |
|       |                   |                                                   |                |     |     |     |     |     |     |     |     |     |

### Druidic

You know Druidic, the secret language of druids. You can speak the language and use it to leave hidden messages. You and others who know this language automatically spot such a message. Others spot the message's presence with a successful DC 15 Wisdom (Perception) check but can't decipher it without magic.

### Spellcasting

Drawing on the divine essence of nature itself, you can cast spells to shape that essence to your will.

#### Cantrips

At 1st level, you know two cantrips of your choice from the druid spell list. You learn additional druid cantrips of your choice at higher levels, as shown in the Cantrips Known column of the Druid table.

#### Preparing and Casting Spells

The Druid table shows how many spell slots you have to cast your druid spells of 1st level and higher. To cast one of these druid spells, you must expend a slot of the spell's level or higher. You regain all expended spell slots when you finish a long rest.

You prepare the list of druid spells that are available for you to cast, choosing from the druid spell list. When you do so, choose a number of druid spells equal to your Wisdom modifier + your druid level (minimum of one spell). The spells must be of a level for which you have spell slots.

For example, if you are a 3rd-level druid, you have four 1st-level and two 2nd-level spell slots. With a Wisdom of 16, your list of prepared spells can include six spells of 1st or 2nd level, in any combination. If you prepare the 1st-level spell *cure wounds*, you can cast it using a 1st-level or 2nd-level slot. Casting the spell doesn't remove it from your list of prepared spells.

You can also change your list of prepared spells when you finish a long rest. Preparing a new list of druid spells requires time spent in prayer and meditation: at least 1 minute per spell level for each spell on your list.

### Spellcasting Ability

Wisdom is your spellcasting ability for your druid spells, since your magic draws upon your devotion and attunement to nature. You use your Wisdom whenever a spell refers to your spellcasting ability. In addition, you use your Wisdom modifier when setting the saving throw DC for a druid spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Wisdom modifier

**Spell attack modifier** = your proficiency bonus + your Wisdom modifier

### Ritual Casting

You can cast a druid spell as a ritual if that spell has the ritual tag and you have the spell prepared.

#### Spellcasting Focus

You can use a druidic focus as a spellcasting focus for your druid spells.

### Wild Shape

Starting at 2nd level, you can use your action to magically assume the shape of a beast that you have seen before. You can use this feature twice. You regain expended uses when you finish a short or long rest.

Your druid level determines the beasts you can transform into, as shown in the Beast Shapes table. At 2nd level, for example, you can transform into any beast that has a challenge rating of 1/4 or lower that doesn't have a flying or swimming speed.

**Table- Beast Shapes**

| Level | Max. CR | Limitations                 | Example     |
|-------|---------|-----------------------------|-------------|
| 2nd   | 1/4     | No flying or swimming speed | Wolf        |
| 4th   | 1/2     | No flying speed             | Crocodile   |
| 8th   | 1       | -                           | Giant eagle |
|       |         |                             |             |

You can stay in a beast shape for a number of hours equal to half your druid level (rounded down). You then revert to your normal form unless you expend another use of this feature. You can revert to your normal form earlier by using a bonus action on your turn. You automatically revert if you fall unconscious, drop to 0 hit points, or die.

While you are transformed, the following rules apply:

- Your game statistics are replaced by the statistics of the beast, but you retain your alignment, personality, and Intelligence, Wisdom, and Charisma scores. You also retain all of your skill and saving throw proficiencies, in addition to gaining those of the creature. If the creature has the same proficiency as you and the bonus in its stat block is higher than yours, use the creature's bonus instead of yours. If the creature has any legendary or lair actions, you can't use them.
- When you transform, you assume the beast's hit points and Hit Dice. When you revert to your normal form, you return to the number of hit points you had before you transformed. However, if you revert as a result of dropping to 0 hit points, any excess damage carries over to your normal form. For example, if you take 10 damage in animal form and have only 1 hit point left, you revert and take 9 damage. As long as the excess damage doesn't reduce your normal form to 0 hit points, you aren't knocked unconscious.
- You can't cast spells, and your ability to speak or take any action that requires hands is limited to the capabilities of your beast form. Transforming doesn't break your concentration on a spell you've already cast, however, or prevent you from taking actions that are part of a spell, such as call lightning, that you've already cast.
- You retain the benefit of any features from your class, race, or other source and can use them if the new form is physically capable of doing so. However, you can't use any of your special senses, such as darkvision, unless your new form also has that sense.
- You choose whether your equipment falls to the ground in your space, merges into your new form, or is worn by it. Worn equipment functions as normal, but the GM decides whether it is practical for the new form to wear a piece of equipment, based on the creature's shape and size. Your equipment doesn't change size or shape to match the new form, and any equipment that the new form can't wear must either fall to the ground or merge with it. Equipment that merges with the form has no effect until you leave the form.

### Druid Circle

At 2nd level, you choose to identify with a circle of druids: the Circle of the Land or the Circle of the Moon, both detailed at the end of the class description. Your choice grants you features at 2nd level and again at 6th, 10th, and 14th level.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Timeless Body

Starting at 18th level, the primal magic that you wield causes you to age more slowly. For every 10 years that pass, your body ages only 1 year.

### Beast Spells

Beginning at 18th level, you can cast many of your druid spells in any shape you assume using Wild Shape. You can perform the somatic and verbal components of a druid spell while in a beast shape, but you aren't able to provide material components.

### Archdruid

At 20th level, you can use your Wild Shape an unlimited number of times.

Additionally, you can ignore the verbal and somatic components of your druid spells, as well as any material components that lack a cost and aren't consumed by a spell. You gain this benefit in both your normal shape and your beast shape from Wild Shape.

## Druid Circles

### Circle of the Land

The Circle of the Land is made up of mystics and sages who safeguard ancient knowledge and rites through a vast oral tradition. These druids meet within sacred circles of trees or standing stones to whisper primal secrets in Druidic. The circle's wisest members preside as the chief priests of communities that hold to the Old Faith and serve as advisors to the rulers of those folk. As a member of this circle, your magic is influenced by the land where you were initiated into the circle's mysterious rites.

#### Bonus Cantrip

When you choose this circle at 2nd level, you learn one additional druid cantrip of your choice.

#### Natural Recovery

Starting at 2nd level, you can regain some of your magical energy by sitting in meditation and communing with nature. During a short rest, you choose expended spell slots to recover. The spell slots can have a combined level that is equal to or less than half your druid level (rounded up), and none of the slots can be 6th level or higher. You can't use this feature again until you finish a long rest.

For example, when you are a 4th-level druid, you can recover up to two levels worth of spell slots. You can recover either a 2nd-level slot or two 1st-level slots.

#### Circle Spells

Your mystical connection to the land infuses you with the ability to cast certain spells. At 3rd, 5th, 7th, and 9th level you gain access to circle spells connected to the land where you became a druid. Choose that land-arctic, coast, desert, forest, grassland, mountain, or swamp-and consult the associated list of spells.

Once you gain access to a circle spell, you always have it prepared, and it doesn't count against the number of spells you can prepare each day. If you gain access to a spell that doesn't appear on the druid spell list, the spell is nonetheless a druid spell for you.

**Table- Arctic Circle Spells**

| Druid Level | Circle Spells                     |
|-------------|-----------------------------------|
| 3rd         | hold person, spike growth         |
| 5th         | sleet storm, slow                 |
| 7th         | freedom of movement, ice storm    |
| 9th         | commune with nature, cone of cold |
|             |                                   |

**Table- Coast Circle Spells**

| Druid Level | Circle Spells                      |
|-------------|------------------------------------|
| 3rd         | mirror image, misty step           |
| 5th         | water breathing, water walk        |
| 7th         | control water, freedom of movement |
| 9th         | conjure elemental, scrying         |
|             |                                    |

**Table- Desert Circle Spells**

| Druid Level | Circle Spells                                 |
|-------------|-----------------------------------------------|
| 3rd         | blur, silence                                 |
| 5th         | create food and water, protection from energy |
| 7th         | blight, hallucinatory terrain                 |
| 9th         | insect plague, wall of stone                  |
|             |                                               |

**Table- Forest Circle Spells**

| Druid Level | Circle Spells                    |
|-------------|----------------------------------|
| 3rd         | barkskin, spider climb           |
| 5th         | call lightning, plant growth     |
| 7th         | divination, freedom of movement  |
| 9th         | commune with nature, tree stride |
|             |                                  |

**Table- Grassland Circle Spells**

| Druid Level | Circle Spells                    |
|-------------|----------------------------------|
| 3rd         | invisibility, pass without trace |
| 5th         | daylight, haste                  |
| 7th         | divination, freedom of movement  |
| 9th         | dream, insect plague             |
|             |                                  |

**Table- Mountain Circle Spells**

| Druid Level | Circle Spells                   |
|-------------|---------------------------------|
| 3rd         | spider climb, spike growth      |
| 5th         | lightning bolt, meld into stone |
| 7th         | stone shape, stoneskin          |
| 9th         | passwall, wall of stone         |
|             |                                 |

**Table- Swamp Circle Spells**

| Druid Level | Circle Spells                        |
|-------------|--------------------------------------|
| 3rd         | acid arrow, darkness                 |
| 5th         | water walk, stinking cloud           |
| 7th         | freedom of movement, locate creature |
| 9th         | insect plague, scrying               |
|             |                                      |

#### Land's Stride

Starting at 6th level, moving through nonmagical difficult terrain costs you no extra movement. You can also pass through nonmagical plants without being slowed by them and without taking damage from them if they have thorns, spines, or a similar hazard.

In addition, you have advantage on saving throws against plants that are magically created or manipulated to impede movement, such those created by the *entangle* spell.

#### Nature's Ward

When you reach 10th level, you can't be charmed or frightened by elementals or fey, and you are immune to poison and disease.

#### Nature's Sanctuary

When you reach 14th level, creatures of the natural world sense your connection to nature and become hesitant to attack you. When a beast or plant creature attacks you, that creature must make a Wisdom saving throw against your druid spell save DC. On a failed save, the creature must choose a different target, or the attack automatically misses. On a successful save, the creature is immune to this effect for 24 hours.

The creature is aware of this effect before it makes its attack against you.

>**Sacred Plants and Wood**

A druid holds certain plants to be sacred, particularly alder, ash, birch, elder, hazel, holly, juniper, mistletoe, oak, rowan, willow, and yew. Druids often use such plants as part of a spellcasting focus, incorporating lengths of oak or yew or sprigs of mistletoe.

Similarly, a druid uses such woods to make other objects, such as weapons and shields. Yew is associated with death and rebirth, so weapon handles for scimitars or sickles might be fashioned from it. Ash is associated with life and oak with strength. These woods make excellent hafts or whole weapons, such as clubs or quarterstaffs, as well as shields. Alder is associated with air, and it might be used for thrown weapons, such as darts or javelins.

Druids from regions that lack the plants described here have chosen other plants to take on similar uses. For instance, a druid of a desert region might value the yucca tree and cactus plants.

**Druids and the Gods**

Some druids venerate the forces of nature themselves, but most druids are devoted to one of the many nature deities worshiped in the multiverse (the lists of gods in appendix B include many such deities). The worship of these deities is often considered a more ancient tradition than the faiths of clerics and urbanized peoples.

## Fighter

### Class Features

As a fighter, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d10 per fighter level

**Hit Points at 1st Level:** 10 + your Constitution modifier

**Hit Points at Higher Levels:** 1d10 (or 6) + your Constitution modifier per fighter level after 1st

#### Proficiencies

**Armor:** All armor, shields

**Weapons:** Simple weapons, martial weapons

**Tools:** None

**Saving Throws:** Strength, Constitution

**Skills:** Choose two skills from Acrobatics, Animal, Handling, Athletics, History, Insight, Intimidation, Perception, and Survival

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) chain mail or (*b*) leather armor, longbow, and 20 arrows
- (*a*) a martial weapon and a shield or (*b*) two martial weapons
- (*a*) a light crossbow and 20 bolts or (*b*) two handaxes
- (*a*) a dungeoneer's pack or (*b*) an explorer's pack

**Table- The Fighter**

| Level | Proficiency Bonus | Features                                          |
|-------|-------------------|---------------------------------------------------|
| 1st   | +2                | Fighting Style, Second Wind                       |
| 2nd   | +2                | Action Surge (one use)                            |
| 3rd   | +2                | Martial Archetype                                 |
| 4th   | +2                | Ability Score Improvement                         |
| 5th   | +3                | Extra Attack                                      |
| 6th   | +3                | Ability Score Improvement                         |
| 7th   | +3                | Martial Archetype Feature                         |
| 8th   | +3                | Ability Score Improvement                         |
| 9th   | +4                | Indomitable (one use)                             |
| 10th  | +4                | Martial Archetype Feature                         |
| 11th  | +4                | Extra Attack (2)                                  |
| 12th  | +4                | Ability Score Improvement                         |
| 13th  | +5                | Indomitable (two uses)                            |
| 14th  | +5                | Ability Score Improvement                         |
| 15th  | +5                | Martial Archetype Feature                         |
| 16th  | +5                | Ability Score Improvement                         |
| 17th  | +6                | Action Surge (two uses), Indomitable (three uses) |
| 18th  | +6                | Martial Archetype Feature                         |
| 19th  | +6                | Ability Score Improvement                         |
| 20th  | +6                | Extra Attack (3)                                  |
|       |                   |                                                   |

### Fighting Style

You adopt a particular style of fighting as your specialty. Choose one of the following options. You can't take a Fighting Style option more than once, even if you later get to choose again.

#### Archery

You gain a +2 bonus to attack rolls you make with ranged weapons.

#### Defense

While you are wearing armor, you gain a +1 bonus to AC.

#### Dueling

When you are wielding a melee weapon in one hand and no other weapons, you gain a +2 bonus to damage rolls with that weapon.

#### Great Weapon Fighting

When you roll a 1 or 2 on a damage die for an attack you make with a melee weapon that you are wielding with two hands, you can reroll the die and must use the new roll, even if the new roll is a 1 or a 2. The weapon must have the two-handed or versatile property for you to gain this benefit.

#### Protection

When a creature you can see attacks a target other than you that is within 5 feet of you, you can use your reaction to impose disadvantage on the attack roll. You must be wielding a shield.

#### Two-Weapon Fighting

When you engage in two-weapon fighting, you can add your ability modifier to the damage of the second attack.

### Second Wind

You have a limited well of stamina that you can draw on to protect yourself from harm. On your turn, you can use a bonus action to regain hit points equal to 1d10 + your fighter level. Once you use this feature, you must finish a short or long rest before you can use it again.

### Action Surge

Starting at 2nd level, you can push yourself beyond your normal limits for a moment. On your turn, you can take one additional action on top of your regular action and a possible bonus action.

Once you use this feature, you must finish a short or long rest before you can use it again. Starting at 17th level, you can use it twice before a rest, but only once on the same turn.

### Martial Archetype

At 3rd level, you choose an archetype that you strive to emulate in your combat styles and techniques. Choose Champion, Battle Master, or Eldritch Knight, all detailed at the end of the class description. The archetype you choose grants you features at 3rd level and again at 7th, 10th, 15th, and 18th level.

### Ability Score Improvement

When you reach 4th level, and again at 6th, 8th, 12th, 14th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Extra Attack

Beginning at 5th level, you can attack twice, instead of once, whenever you take the Attack action on your turn.

The number of attacks increases to three when you reach 11th level in this class and to four when you reach 20th level in this class.

### Indomitable

Beginning at 9th level, you can reroll a saving throw that you fail. If you do so, you must use the new roll, and you can't use this feature again until you finish a long rest.

You can use this feature twice between long rests starting at 13th level and three times between long rests starting at 17th level.

## Martial Archetypes

Different fighters choose different approaches to perfecting their fighting prowess. The martial archetype you choose to emulate reflects your approach.

### Champion

The archetypal Champion focuses on the development of raw physical power honed to deadly perfection. Those who model themselves on this archetype combine rigorous training with physical excellence to deal devastating blows.

#### Improved Critical

Beginning when you choose this archetype at 3rd level, your weapon attacks score a critical hit on a roll of 19 or 20.

#### Remarkable Athlete

Starting at 7th level, you can add half your proficiency bonus (round up) to any Strength, Dexterity, or Constitution check you make that doesn't already use your proficiency bonus.

In addition, when you make a running long jump, the distance you can cover increases by a number of feet equal to your Strength modifier.

#### Additional Fighting Style

At 10th level, you can choose a second option from the Fighting Style class feature.

#### Superior Critical

Starting at 15th level, your weapon attacks score a critical hit on a roll of 18-20.

#### Survivor

At 18th level, you attain the pinnacle of resilience in battle. At the start of each of your turns, you regain hit points equal to 5 + your Constitution modifier if you have no more than half of your hit points left. You don't gain this benefit if you have 0 hit points.

## Fighter

### Class Features

As a fighter, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d10 per fighter level

**Hit Points at 1st Level:** 10 + your Constitution modifier

**Hit Points at Higher Levels:** 1d10 (or 6) + your Constitution modifier per fighter level after 1st

#### Proficiencies

**Armor:** All armor, shields

**Weapons:** Simple weapons, martial weapons

**Tools:** None

**Saving Throws:** Strength, Constitution

**Skills:** Choose two skills from Acrobatics, Animal, Handling, Athletics, History, Insight, Intimidation, Perception, and Survival

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) chain mail or (*b*) leather armor, longbow, and 20 arrows
- (*a*) a martial weapon and a shield or (*b*) two martial weapons
- (*a*) a light crossbow and 20 bolts or (*b*) two handaxes
- (*a*) a dungeoneer's pack or (*b*) an explorer's pack

**Table- The Fighter**

| Level | Proficiency Bonus | Features                                          |
|-------|-------------------|---------------------------------------------------|
| 1st   | +2                | Fighting Style, Second Wind                       |
| 2nd   | +2                | Action Surge (one use)                            |
| 3rd   | +2                | Martial Archetype                                 |
| 4th   | +2                | Ability Score Improvement                         |
| 5th   | +3                | Extra Attack                                      |
| 6th   | +3                | Ability Score Improvement                         |
| 7th   | +3                | Martial Archetype Feature                         |
| 8th   | +3                | Ability Score Improvement                         |
| 9th   | +4                | Indomitable (one use)                             |
| 10th  | +4                | Martial Archetype Feature                         |
| 11th  | +4                | Extra Attack (2)                                  |
| 12th  | +4                | Ability Score Improvement                         |
| 13th  | +5                | Indomitable (two uses)                            |
| 14th  | +5                | Ability Score Improvement                         |
| 15th  | +5                | Martial Archetype Feature                         |
| 16th  | +5                | Ability Score Improvement                         |
| 17th  | +6                | Action Surge (two uses), Indomitable (three uses) |
| 18th  | +6                | Martial Archetype Feature                         |
| 19th  | +6                | Ability Score Improvement                         |
| 20th  | +6                | Extra Attack (3)                                  |
|       |                   |                                                   |

### Fighting Style

You adopt a particular style of fighting as your specialty. Choose one of the following options. You can't take a Fighting Style option more than once, even if you later get to choose again.

#### Archery

You gain a +2 bonus to attack rolls you make with ranged weapons.

#### Defense

While you are wearing armor, you gain a +1 bonus to AC.

#### Dueling

When you are wielding a melee weapon in one hand and no other weapons, you gain a +2 bonus to damage rolls with that weapon.

#### Great Weapon Fighting

When you roll a 1 or 2 on a damage die for an attack you make with a melee weapon that you are wielding with two hands, you can reroll the die and must use the new roll, even if the new roll is a 1 or a 2. The weapon must have the two-handed or versatile property for you to gain this benefit.

#### Protection

When a creature you can see attacks a target other than you that is within 5 feet of you, you can use your reaction to impose disadvantage on the attack roll. You must be wielding a shield.

#### Two-Weapon Fighting

When you engage in two-weapon fighting, you can add your ability modifier to the damage of the second attack.

### Second Wind

You have a limited well of stamina that you can draw on to protect yourself from harm. On your turn, you can use a bonus action to regain hit points equal to 1d10 + your fighter level. Once you use this feature, you must finish a short or long rest before you can use it again.

### Action Surge

Starting at 2nd level, you can push yourself beyond your normal limits for a moment. On your turn, you can take one additional action on top of your regular action and a possible bonus action.

Once you use this feature, you must finish a short or long rest before you can use it again. Starting at 17th level, you can use it twice before a rest, but only once on the same turn.

### Martial Archetype

At 3rd level, you choose an archetype that you strive to emulate in your combat styles and techniques. Choose Champion, Battle Master, or Eldritch Knight, all detailed at the end of the class description. The archetype you choose grants you features at 3rd level and again at 7th, 10th, 15th, and 18th level.

### Ability Score Improvement

When you reach 4th level, and again at 6th, 8th, 12th, 14th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Extra Attack

Beginning at 5th level, you can attack twice, instead of once, whenever you take the Attack action on your turn.

The number of attacks increases to three when you reach 11th level in this class and to four when you reach 20th level in this class.

### Indomitable

Beginning at 9th level, you can reroll a saving throw that you fail. If you do so, you must use the new roll, and you can't use this feature again until you finish a long rest.

You can use this feature twice between long rests starting at 13th level and three times between long rests starting at 17th level.

## Martial Archetypes

Different fighters choose different approaches to perfecting their fighting prowess. The martial archetype you choose to emulate reflects your approach.

### Champion

The archetypal Champion focuses on the development of raw physical power honed to deadly perfection. Those who model themselves on this archetype combine rigorous training with physical excellence to deal devastating blows.

#### Improved Critical

Beginning when you choose this archetype at 3rd level, your weapon attacks score a critical hit on a roll of 19 or 20.

#### Remarkable Athlete

Starting at 7th level, you can add half your proficiency bonus (round up) to any Strength, Dexterity, or Constitution check you make that doesn't already use your proficiency bonus.

In addition, when you make a running long jump, the distance you can cover increases by a number of feet equal to your Strength modifier.

#### Additional Fighting Style

At 10th level, you can choose a second option from the Fighting Style class feature.

#### Superior Critical

Starting at 15th level, your weapon attacks score a critical hit on a roll of 18-20.

#### Survivor

At 18th level, you attain the pinnacle of resilience in battle. At the start of each of your turns, you regain hit points equal to 5 + your Constitution modifier if you have no more than half of your hit points left. You don't gain this benefit if you have 0 hit points.

## Monk

### Class Features

As a monk, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d8 per monk level

**Hit Points at 1st Level:** 8 + your Constitution modifier

**Hit Points at Higher Levels:** 1d8 (or 5) + your Constitution modifier per monk level after 1st

#### Proficiencies

**Armor:** None

**Weapons:** Simple weapons, shortswords

**Tools:** Choose one type of artisan's tools or one musical instrument

**Saving Throws:** Strength, Dexterity

**Skills:** Choose two from Acrobatics, Athletics, History, Insight, Religion, and Stealth

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a shortsword or (*b*) any simple weapon
- (*a*) a dungeoneer's pack or (*b*) an explorer's pack
- 10 darts

**Table- The Monk**

| Level | Proficiency Bonus | Martial Arts | Ki Points | Unarmored Movement | Features                                         |
|-------|-------------------|--------------|-----------|--------------------|--------------------------------------------------|
| 1st   | +2                | 1d4          | -         | -                  | Unarmored Defense, Martial Arts                  |
| 2nd   | +2                | 1d4          | 2         | +10 ft.            | Ki, Unarmored Movement                           |
| 3rd   | +2                | 1d4          | 3         | +10 ft.            | Monastic Tradition, Deflect Missiles             |
| 4th   | +2                | 1d4          | 4         | +10 ft.            | Ability Score Improvement, Slow Fall             |
| 5th   | +3                | 1d6          | 5         | +10 ft.            | Extra Attack, Stunning Strike                    |
| 6th   | +3                | 1d6          | 6         | +15 ft.            | Ki-Empowered Strikes, Monastic Tradition Feature |
| 7th   | +3                | 1d6          | 7         | +15 ft.            | Evasion, Stillness of Mind                       |
| 8th   | +3                | 1d6          | 8         | +15 ft.            | Ability Score Improvement                        |
| 9th   | +4                | 1d6          | 9         | +15 ft.            | Unarmored Movement improvement                   |
| 10th  | +4                | 1d6          | 10        | +20 ft.            | Purity of Body                                   |
| 11th  | +4                | 1d8          | 11        | +20 ft.            | Monastic Tradition Feature                       |
| 12th  | +4                | 1d8          | 12        | +20 ft.            | Ability Score Improvement                        |
| 13th  | +5                | 1d8          | 13        | +20 ft.            | Tongue of the Sun and Moon                       |
| 14th  | +5                | 1d8          | 14        | +25 ft.            | Diamond Soul                                     |
| 15th  | +5                | 1d8          | 15        | +25 ft.            | Timeless Body                                    |
| 16th  | +5                | 1d8          | 16        | +25 ft.            | Ability Score Improvement                        |
| 17th  | +6                | 1d10         | 17        | +25 ft.            | Monastic Tradition Feature                       |
| 18th  | +6                | 1d10         | 18        | +30 ft.            | Empty Body                                       |
| 19th  | +6                | 1d10         | 19        | +30 ft.            | Ability Score Improvement                        |
| 20th  | +6                | 1d10         | 20        | +30 ft.            | Perfect Self                                     |
|       |                   |              |           |                    |                                                  |

### Unarmored Defense

Beginning at 1st level, while you are wearing no armor and not wielding a shield, your AC equals 10 + your Dexterity modifier + your Wisdom modifier.

### Martial Arts

At 1st level, your practice of martial arts gives you mastery of combat styles that use unarmed strikes and monk weapons, which are shortswords and any simple melee weapons that don't have the two- handed or heavy property.

You gain the following benefits while you are unarmed or wielding only monk weapons and you aren't wearing armor or wielding a shield:

- You can use Dexterity instead of Strength for the attack and damage rolls of your unarmed strikes and monk weapons.
- You can roll a d4 in place of the normal damage of your unarmed strike or monk weapon. This die changes as you gain monk levels, as shown in the Martial Arts column of the Monk table.
- When you use the Attack action with an unarmed strike or a monk weapon on your turn, you can make one unarmed strike as a bonus action. For example, if you take the Attack action and attack with a quarterstaff, you can also make an unarmed strike as a bonus action, assuming you haven't already taken a bonus action this turn.

Certain monasteries use specialized forms of the monk weapons. For example, you might use a club that is two lengths of wood connected by a short chain (called a nunchaku) or a sickle with a shorter, straighter blade (called a kama). Whatever name you use for a monk weapon, you can use the game statistics provided for the weapon.

### Ki

Starting at 2nd level, your training allows you to harness the mystic energy of ki. Your access to this energy is represented by a number of ki points. Your monk level determines the number of points you have, as shown in the Ki Points column of the Monk table.

You can spend these points to fuel various ki features. You start knowing three such features: Flurry of Blows, Patient Defense, and Step of the Wind. You learn more ki features as you gain levels in this class.

When you spend a ki point, it is unavailable until you finish a short or long rest, at the end of which you draw all of your expended ki back into yourself. You must spend at least 30 minutes of the rest meditating to regain your ki points.

Some of your ki features require your target to make a saving throw to resist the feature's effects. The saving throw DC is calculated as follows:

**Ki save DC** = 8 + your proficiency bonus + your Wisdom modifier

#### Flurry of Blows

Immediately after you take the Attack action on your turn, you can spend 1 ki point to make two unarmed strikes as a bonus action.

#### Patient Defense

You can spend 1 ki point to take the Dodge action as a bonus action on your turn.

#### Step of the Wind

You can spend 1 ki point to take the Disengage or Dash action as a bonus action on your turn, and your jump distance is doubled for the turn.

### Unarmored Movement

Starting at 2nd level, your speed increases by 10 feet while you are not wearing armor or wielding a shield. This bonus increases when you reach certain monk levels, as shown in the Monk table.

At 9th level, you gain the ability to move along vertical surfaces and across liquids on your turn without falling during the move.

### Monastic Tradition

When you reach 3rd level, you commit yourself to a monastic tradition: the Way of the Open Hand, the Way of Shadow, or the Way of the Four Elements, all detailed at the end of the class description. Your tradition grants you features at 3rd level and again at 6th, 11th, and 17th level.

### Deflect Missiles

Starting at 3rd level, you can use your reaction to deflect or catch the missile when you are hit by a ranged weapon attack. When you do so, the damage you take from the attack is reduced by 1d10 + your Dexterity modifier + your monk level.

If you reduce the damage to 0, you can catch the missile if it is small enough for you to hold in one hand and you have at least one hand free. If you catch a missile in this way, you can spend 1 ki point to make a ranged attack with the weapon or piece of ammunition you just caught, as part of the same reaction. You make this attack with proficiency, regardless of your weapon proficiencies, and the missile counts as a monk weapon for the attack, which has a normal range of 20 feet and a long range of 60 feet.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Slow Fall

Beginning at 4th level, you can use your reaction when you fall to reduce any falling damage you take by an amount equal to five times your monk level.

### Extra Attack

Beginning at 5th level, you can attack twice, instead of once, whenever you take the Attack action on your turn.

### Stunning Strike

Starting at 5th level, you can interfere with the flow of ki in an opponent's body. When you hit another creature with a melee weapon attack, you can spend 1 ki point to attempt a stunning strike. The target must succeed on a Constitution saving throw or be stunned until the end of your next turn.

### Ki-Empowered Strikes

Starting at 6th level, your unarmed strikes count as magical for the purpose of overcoming resistance and immunity to nonmagical attacks and damage.

### Evasion

At 7th level, your instinctive agility lets you dodge out of the way of certain area effects, such as a blue dragon's lightning breath or a *fireball* spell. When you are subjected to an effect that allows you to make a Dexterity saving throw to take only half damage, you instead take no damage if you succeed on the saving throw, and only half damage if you fail.

### Stillness of Mind

Starting at 7th level, you can use your action to end one effect on yourself that is causing you to be charmed or frightened.

### Purity of Body

At 10th level, your mastery of the ki flowing through you makes you immune to disease and poison.

### Tongue of the Sun and Moon

Starting at 13th level, you learn to touch the ki of other minds so that you understand all spoken languages. Moreover, any creature that can understand a language can understand what you say.

### Diamond Soul

Beginning at 14th level, your mastery of ki grants you proficiency in all saving throws.

Additionally, whenever you make a saving throw and fail, you can spend 1 ki point to reroll it and take the second result.

### Timeless Body

At 15th level, your ki sustains you so that you suffer none of the frailty of old age, and you can't be aged magically. You can still die of old age, however. In addition, you no longer need food or water.

### Empty Body

Beginning at 18th level, you can use your action to spend 4 ki points to become invisible for 1 minute. During that time, you also have resistance to all damage but force damage.

Additionally, you can spend 8 ki points to cast the *astral projection* spell, without needing material components. When you do so, you can't take any other creatures with you.

### Perfect Self

At 20th level, when you roll for initiative and have no ki points remaining, you regain 4 ki points.

## Monastic Traditions

Three traditions of monastic pursuit are common in the monasteries scattered across the multiverse. Most monasteries practice one tradition exclusively, but a few honor the three traditions and instruct each monk according to his or her aptitude and interest. All three traditions rely on the same basic techniques, diverging as the student grows more adept. Thus, a monk need choose a tradition only upon reaching 3rd level.

### Way of the Open Hand

Monks of the Way of the Open Hand are the ultimate masters of martial arts combat, whether armed or unarmed. They learn techniques to push and trip their opponents, manipulate ki to heal damage to their bodies, and practice advanced meditation that can protect them from harm.

#### Open Hand Technique

Starting when you choose this tradition at 3rd level, you can manipulate your enemy's ki when you harness your own. Whenever you hit a creature with one of the attacks granted by your Flurry of Blows, you can impose one of the following effects on that target:

- It must succeed on a Dexterity saving throw or be knocked prone.
- It must make a Strength saving throw. If it fails, you can push it up to 15 feet away from you.
- It can't take reactions until the end of your next turn.

#### Wholeness of Body

At 6th level, you gain the ability to heal yourself. As an action, you can regain hit points equal to three times your monk level. You must finish a long rest before you can use this feature again.

#### Tranquility

Beginning at 11th level, you can enter a special meditation that surrounds you with an aura of peace. At the end of a long rest, you gain the effect of a *sanctuary* spell that lasts until the start of your next long rest (the spell can end early as normal). The saving throw DC for the spell equals 8 + your Wisdom modifier + your proficiency bonus.

#### Quivering Palm

At 17th level, you gain the ability to set up lethal vibrations in someone's body. When you hit a creature with an unarmed strike, you can spend 3 ki points to start these imperceptible vibrations, which last for a number of days equal to your monk level. The vibrations are harmless unless you use your action to end them. To do so, you and the target must be on the same plane of existence. When you use this action, the creature must make a Constitution saving throw. If it fails, it is reduced to 0 hit points. If it succeeds, it takes 10d10 necrotic damage.

You can have only one creature under the effect of this feature at a time. You can choose to end the vibrations harmlessly without using an action.

## Paladin

### Class Features

As a paladin, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d10 per paladin level

**Hit Points at 1st Level:** 10 + your Constitution modifier

**Hit Points at Higher Levels:** 1d10 (or 6) + your Constitution modifier per paladin level after 1st

#### Proficiencies

**Armor:** All armor, shields

**Weapons:** Simple weapons, martial weapons

**Tools:** None

**Saving Throws:** Wisdom, Charisma

**Skills:** Choose two from Athletics, Insight, Intimidation, Medicine, Persuasion, and Religion

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a martial weapon and a shield or (*b*) two martial weapons
- (*a*) five javelins or (*b*) any simple melee weapon
- (*a*) a priest's pack or (*b*) an explorer's pack
- Chain mail and a holy symbol

**Table- The Paladin**

| Level | Proficiency Bonus | Features                                   | 1st | 2nd | 3rd | 4th | 5th |
|-------|-------------------|--------------------------------------------|-----|-----|-----|-----|-----|
| 1st   | +2                | Divine Sense, Lay on Hands                 | -   | -   | -   | -   | -   |
| 2nd   | +2                | Fighting Style, Spellcasting, Divine Smite | 2   | -   | -   | -   | -   |
| 3rd   | +2                | Divine Health, Sacred Oath                 | 3   | -   | -   | -   | -   |
| 4th   | +2                | Ability Score Improvement                  | 3   | -   | -   | -   | -   |
| 5th   | +3                | Extra Attack                               | 4   | 2   | -   | -   | -   |
| 6th   | +3                | Aura of Protection                         | 4   | 2   | -   | -   | -   |
| 7th   | +3                | Sacred Oath feature                        | 4   | 3   | -   | -   | -   |
| 8th   | +3                | Ability Score Improvement                  | 4   | 3   | -   | -   | -   |
| 9th   | +4                | -                                          | 4   | 3   | 2   | -   | -   |
| 10th  | +4                | Aura of Courage                            | 4   | 3   | 2   | -   | -   |
| 11th  | +4                | Improved Divine Smite                      | 4   | 3   | 3   | -   | -   |
| 12th  | +4                | Ability Score Improvement                  | 4   | 3   | 3   | -   | -   |
| 13th  | +5                | -                                          | 4   | 3   | 3   | 1   | -   |
| 14th  | +5                | Cleansing Touch                            | 4   | 3   | 3   | 1   | -   |
| 15th  | +5                | Sacred Oath feature                        | 4   | 3   | 3   | 2   | -   |
| 16th  | +5                | Ability Score Improvement                  | 4   | 3   | 3   | 2   | -   |
| 17th  | +6                | -                                          | 4   | 3   | 3   | 3   | 1   |
| 18th  | +6                | Aura improvements                          | 4   | 3   | 3   | 3   | 1   |
| 19th  | +6                | Ability Score Improvement                  | 4   | 3   | 3   | 3   | 2   |
| 20th  | +6                | Sacred Oath feature                        | 4   | 3   | 3   | 3   | 2   |
|       |                   |                                            |     |     |     |     |     |

### Divine Sense

The presence of strong evil registers on your senses like a noxious odor, and powerful good rings like heavenly music in your ears. As an action, you can open your awareness to detect such forces. Until the end of your next turn, you know the location of any celestial, fiend, or undead within 60 feet of you that is not behind total cover. You know the type (celestial, fiend, or undead) of any being whose presence you sense, but not its identity (the vampire Count Strahd von Zarovich, for instance). Within the same radius, you also detect the presence of any place or object that has been consecrated or desecrated, as with the *hallow* spell.

You can use this feature a number of times equal to 1 + your Charisma modifier. When you finish a long rest, you regain all expended uses.

### Lay on Hands

Your blessed touch can heal wounds. You have a pool of healing power that replenishes when you take a long rest. With that pool, you can restore a total number of hit points equal to your paladin level × 5.

As an action, you can touch a creature and draw power from the pool to restore a number of hit points to that creature, up to the maximum amount remaining in your pool.

Alternatively, you can expend 5 hit points from your pool of healing to cure the target of one disease or neutralize one poison affecting it. You can cure multiple diseases and neutralize multiple poisons with a single use of Lay on Hands, expending hit points separately for each one.

This feature has no effect on undead and constructs.

### Fighting Style

At 2nd level, you adopt a style of fighting as your specialty. Choose one of the following options. You can't take a Fighting Style option more than once, even if you later get to choose again.

#### Defense

While you are wearing armor, you gain a +1 bonus to AC.

#### Dueling

When you are wielding a melee weapon in one hand and no other weapons, you gain a +2 bonus to damage rolls with that weapon.

#### Great Weapon Fighting

When you roll a 1 or 2 on a damage die for an attack you make with a melee weapon that you are wielding with two hands, you can reroll the die and must use the new roll. The weapon must have the two-handed or versatile property for you to gain this benefit.

#### Protection

When a creature you can see attacks a target other than you that is within 5 feet of you, you can use your reaction to impose disadvantage on the attack roll. You must be wielding a shield.

### Spellcasting

By 2nd level, you have learned to draw on divine magic through meditation and prayer to cast spells as a cleric does.

#### Preparing and Casting Spells

The Paladin table shows how many spell slots you have to cast your paladin spells. To cast one of your paladin spells of 1st level or higher, you must expend a slot of the spell's level or higher. You regain all expended spell slots when you finish a long rest.

You prepare the list of paladin spells that are available for you to cast, choosing from the paladin spell list. When you do so, choose a number of paladin spells equal to your Charisma modifier + half your paladin level, rounded down (minimum of one spell). The spells must be of a level for which you have spell slots.

For example, if you are a 5th-level paladin, you have four 1st-level and two 2nd-level spell slots. With a Charisma of 14, your list of prepared spells can include four spells of 1st or 2nd level, in any combination. If you prepare the 1st-level spell *cure wounds*, you can cast it using a 1st-level or a 2nd- level slot. Casting the spell doesn't remove it from your list of prepared spells.

You can change your list of prepared spells when you finish a long rest. Preparing a new list of paladin spells requires time spent in prayer and meditation: at least 1 minute per spell level for each spell on your list.

#### Spellcasting Ability

Charisma is your spellcasting ability for your paladin spells, since their power derives from the strength of your convictions. You use your Charisma whenever a spell refers to your spellcasting ability. In addition, you use your Charisma modifier when setting the saving throw DC for a paladin spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Charisma modifier

**Spell attack modifier** = your proficiency bonus + your Charisma modifier

#### Spellcasting Focus

You can use a holy symbol as a spellcasting focus for your paladin spells.

### Divine Smite

Starting at 2nd level, when you hit a creature with a melee weapon attack, you can expend one spell slot to deal radiant damage to the target, in addition to the weapon's damage. The extra damage is 2d8 for a 1st-level spell slot, plus 1d8 for each spell level higher than 1st, to a maximum of 5d8. The damage increases by 1d8 if the target is an undead or a fiend, to a maximum of 6d8.

### Divine Health

By 3rd level, the divine magic flowing through you makes you immune to disease.

### Sacred Oath

When you reach 3rd level, you swear the oath that binds you as a paladin forever. Up to this time you have been in a preparatory stage, committed to the path but not yet sworn to it. Now you choose the Oath of Devotion, the Oath of the Ancients, or the Oath of Vengeance, all detailed at the end of the class description.

Your choice grants you features at 3rd level and again at 7th, 15th, and 20th level. Those features include oath spells and the Channel Divinity feature.

#### Oath Spells

Each oath has a list of associated spells. You gain access to these spells at the levels specified in the oath description. Once you gain access to an oath spell, you always have it prepared. Oath spells don't count against the number of spells you can prepare each day.

If you gain an oath spell that doesn't appear on the paladin spell list, the spell is nonetheless a paladin spell for you.

#### Channel Divinity

Your oath allows you to channel divine energy to fuel magical effects. Each Channel Divinity option provided by your oath explains how to use it.

When you use your Channel Divinity, you choose which option to use. You must then finish a short or long rest to use your Channel Divinity again.

Some Channel Divinity effects require saving throws. When you use such an effect from this class, the DC equals your paladin spell save DC.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Extra Attack

Beginning at 5th level, you can attack twice, instead of once, whenever you take the Attack action on your turn.

### Aura of Protection

Starting at 6th level, whenever you or a friendly creature within 10 feet of you must make a saving throw, the creature gains a bonus to the saving throw equal to your Charisma modifier (with a minimum bonus of +1). You must be conscious to grant this bonus.

At 18th level, the range of this aura increases to 30 feet.

### Aura of Courage

Starting at 10th level, you and friendly creatures within 10 feet of you can't be frightened while you are conscious.

At 18th level, the range of this aura increases to 30 feet.

### Improved Divine Smite

By 11th level, you are so suffused with righteous might that all your melee weapon strikes carry divine power with them. Whenever you hit a creature with a melee weapon, the creature takes an extra 1d8 radiant damage. If you also use your Divine Smite with an attack, you add this damage to the extra damage of your Divine Smite.

### Cleansing Touch

Beginning at 14th level, you can use your action to end one spell on yourself or on one willing creature that you touch.

You can use this feature a number of times equal to your Charisma modifier (a minimum of once). You regain expended uses when you finish a long rest.

## Sacred Oaths

Becoming a paladin involves taking vows that commit the paladin to the cause of righteousness, an active path of fighting wickedness. The final oath, taken when he or she reaches 3rd level, is the culmination of all the paladin's training. Some characters with this class don't consider themselves true paladins until they have reached 3rd level and made this oath. For others, the actual swearing of the oath is a formality, an official stamp on what has always been true in the paladin's heart.

### Oath of Devotion

The Oath of Devotion binds a paladin to the loftiest ideals of justice, virtue, and order. Sometimes called cavaliers, white knights, or holy warriors, these paladins meet the ideal of the knight in shining armor, acting with honor in pursuit of justice and the greater good. They hold themselves to the highest standards of conduct, and some, for better or worse, hold the rest of the world to the same standards. Many who swear this oath are devoted to gods of law and good and use their gods' tenets as the measure of their devotion. They hold angels-the perfect servants of good-as their ideals, and incorporate images of angelic wings into their helmets or coats of arms.

#### Tenets of Devotion

Though the exact words and strictures of the Oath of Devotion vary, paladins of this oath share these tenets.

***Honesty***. Don't lie or cheat. Let your word be your promise.

***Courage***. Never fear to act, though caution is wise.

***Compassion***. Aid others, protect the weak, and punish those who threaten them. Show mercy to your foes, but temper it with wisdom.

***Honor***. Treat others with fairness, and let your honorable deeds be an example to them. Do as much good as possible while causing the least amount of harm.

***Duty***. Be responsible for your actions and their consequences, protect those entrusted to your care, and obey those who have just authority over you.

#### Oath Spells

You gain oath spells at the paladin levels listed.

**Table- Oath of Devotion Spells**

| Level | Paladin Spells                           |
|-------|------------------------------------------|
| 3rd   | protection from evil and good, sanctuary |
| 5th   | lesser restoration, zone of truth        |
| 9th   | beacon of hope, dispel magic             |
| 13th  | freedom of movement, guardian of faith   |
| 17th  | commune, flame strike                    |
|       |                                          |

#### Channel Divinity

When you take this oath at 3rd level, you gain the following two Channel Divinity options.

***Sacred Weapon***. As an action, you can imbue one weapon that you are holding with positive energy, using your Channel Divinity. For 1 minute, you add your Charisma modifier to attack rolls made with that weapon (with a minimum bonus of +1). The weapon also emits bright light in a 20-foot radius and dim light 20 feet beyond that. If the weapon is not already magical, it becomes magical for the duration.

You can end this effect on your turn as part of any other action. If you are no longer holding or carrying this weapon, or if you fall unconscious, this effect ends.

***Turn the Unholy***. As an action, you present your holy symbol and speak a prayer censuring fiends and undead, using your Channel Divinity. Each fiend or undead that can see or hear you within 30 feet of you must make a Wisdom saving throw. If the creature fails its saving throw, it is turned for 1 minute or until it takes damage.

A turned creature must spend its turns trying to move as far away from you as it can, and it can't willingly move to a space within 30 feet of you. It also can't take reactions. For its action, it can use only the Dash action or try to escape from an effect that prevents it from moving. If there's nowhere to move, the creature can use the Dodge action.

#### Aura of Devotion

Starting at 7th level, you and friendly creatures within 10 feet of you can't be charmed while you are conscious.

At 18th level, the range of this aura increases to 30 feet.

##### Purity of Spirit

Beginning at 15th level, you are always under the effects of a *protection from evil and good* spell.

#### Holy Nimbus

At 20th level, as an action, you can emanate an aura of sunlight. For 1 minute, bright light shines from you in a 30-foot radius, and dim light shines 30 feet beyond that.

Whenever an enemy creature starts its turn in the bright light, the creature takes 10 radiant damage.

In addition, for the duration, you have advantage on saving throws against spells cast by fiends or undead.

Once you use this feature, you can't use it again until you finish a long rest.

**Breaking Your Oath**

A paladin tries to hold to the highest standards of conduct, but even the most virtuous paladin is fallible. Sometimes the right path proves too demanding, sometimes a situation calls for the lesser of two evils, and sometimes the heat of emotion causes a paladin to transgress his or her oath.

A paladin who has broken a vow typically seeks absolution from a cleric who shares his or her faith or from another paladin of the same order. The paladin might spend an all- night vigil in prayer as a sign of penitence, or undertake a fast or similar act of self-denial. After a rite of confession and forgiveness, the paladin starts fresh.

If a paladin willfully violates his or her oath and shows no sign of repentance, the consequences can be more serious. At the GM's discretion, an impenitent paladin might be forced to abandon this class and adopt another.

## Ranger

### Class Features

As a ranger, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d10 per ranger level

**Hit Points at 1st Level:** 10 + your Constitution modifier

**Hit Points at Higher Levels:** 1d10 (or 6) + your Constitution modifier per ranger level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, shields

**Weapons:** Simple weapons, martial weapons

**Tools:** None

**Saving Throws:** Strength, Dexterity

**Skills:** Choose three from Animal Handling, Athletics, Insight, Investigation, Nature, Perception, Stealth, and Survival

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) scale mail or (*b*) leather armor
- (*a*) two shortswords or (*b*) two simple melee weapons
- (*a*) a dungeoneer's pack or (*b*) an explorer's pack
- A longbow and a quiver of 20 arrows

**Table- The Ranger**

| Level | Proficiency Bonus | Features                                          | Spells Known | 1st | 2nd | 3rd | 4th | 5th |
|-------|-------------------|---------------------------------------------------|--------------|-----|-----|-----|-----|-----|
| 1st   | +2                | Favored Enemy, Natural Explorer                   | -            | -   | -   | -   | -   | -   |
| 2nd   | +2                | Fighting Style, Spellcasting                      | 2            | 2   | -   | -   | -   | -   |
| 3rd   | +2                | Ranger Archetype, Primeval Awareness              | 3            | 3   | -   | -   | -   | -   |
| 4th   | +2                | Ability Score Improvement                         | 3            | 3   | -   | -   | -   | -   |
| 5th   | +3                | Extra Attack                                      | 4            | 4   | 2   | -   | -   | -   |
| 6th   | +3                | Favored Enemy and Natural Explorer improvements   | 4            | 4   | 2   | -   | -   | -   |
| 7th   | +3                | Ranger Archetype feature                          | 5            | 4   | 3   | -   | -   | -   |
| 8th   | +3                | Ability Score Improvement, Land's Stride          | 5            | 4   | 3   | -   | -   | -   |
| 9th   | +4                | -                                                 | 6            | 4   | 3   | 2   | -   | -   |
| 10th  | +4                | Natural Explorer improvement, Hide in Plain Sight | 6            | 4   | 3   | 2   | -   | -   |
| 11th  | +4                | Ranger Archetype feature                          | 7            | 4   | 3   | 3   | -   | -   |
| 12th  | +4                | Ability Score Improvement                         | 7            | 4   | 3   | 3   | -   | -   |
| 13th  | +5                | -                                                 | 8            | 4   | 3   | 3   | 1   | -   |
| 14th  | +5                | Favored Enemy improvement, Vanish                 | 8            | 4   | 3   | 3   | 1   | -   |
| 15th  | +5                | Ranger Archetype feature                          | 9            | 4   | 3   | 3   | 2   | -   |
| 16th  | +5                | Ability Score Improvement                         | 9            | 4   | 3   | 3   | 2   | -   |
| 17th  | +6                | -                                                 | 10           | 4   | 3   | 3   | 3   | 1   |
| 18th  | +6                | Feral Senses                                      | 10           | 4   | 3   | 3   | 3   | 1   |
| 19th  | +6                | Ability Score Improvement                         | 11           | 4   | 3   | 3   | 3   | 2   |
| 20th  | +6                | Foe Slayer                                        | 11           | 4   | 3   | 3   | 3   | 2   |
|       |                   |                                                   |              |     |     |     |     |     |

### Favored Enemy

Beginning at 1st level, you have significant experience studying, tracking, hunting, and even talking to a certain type of enemy.

Choose a type of favored enemy: aberrations, beasts, celestials, constructs, dragons, elementals, fey, fiends, giants, monstrosities, oozes, plants, or undead. Alternatively, you can select two races of humanoid (such as gnolls and orcs) as favored enemies.

You have advantage on Wisdom (Survival) checks to track your favored enemies, as well as on Intelligence checks to recall information about them.

When you gain this feature, you also learn one language of your choice that is spoken by your favored enemies, if they speak one at all.

You choose one additional favored enemy, as well as an associated language, at 6th and 14th level. As you gain levels, your choices should reflect the types of monsters you have encountered on your adventures.

### Natural Explorer

You are particularly familiar with one type of natural environment and are adept at traveling and surviving in such regions. Choose one type of favored terrain: arctic, coast, desert, forest, grassland, mountain, or swamp. When you make an Intelligence or Wisdom check related to your favored terrain, your proficiency bonus is doubled if you are using a skill that you're proficient in.

While traveling for an hour or more in your favored terrain, you gain the following benefits:

- Difficult terrain doesn't slow your group's travel.
- Your group can't become lost except by magical means.
- Even when you are engaged in another activity while traveling (such as foraging, navigating, or tracking), you remain alert to danger.
- If you are traveling alone, you can move stealthily at a normal pace.
- When you forage, you find twice as much food as you normally would.
- While tracking other creatures, you also learn their exact number, their sizes, and how long ago they passed through the area.

You choose additional favored terrain types at 6th and 10th level.

### Fighting Style

At 2nd level, you adopt a particular style of fighting as your specialty. Choose one of the following options. You can't take a Fighting Style option more than once, even if you later get to choose again.

#### Archery

You gain a +2 bonus to attack rolls you make with ranged weapons.

#### Defense

While you are wearing armor, you gain a +1 bonus to AC.

#### Dueling

When you are wielding a melee weapon in one hand and no other weapons, you gain a +2 bonus to damage rolls with that weapon.

#### Two-Weapon Fighting

When you engage in two-weapon fighting, you can add your ability modifier to the damage of the second attack.

### Spellcasting

By the time you reach 2nd level, you have learned to use the magical essence of nature to cast spells, much as a druid does. See the general rules for spellcasting and the ranger spell list.

#### Spell Slots

The Ranger table shows how many spell slots you have to cast your ranger spells of 1st level and higher. To cast one of these spells, you must expend a slot of the spell's level or higher. You regain all expended spell slots when you finish a long rest.

For example, if you know the 1st-level spell *animal friendship* and have a 1st-level and a 2nd-level spell slot available, you can cast *animal friendship* using either slot.

#### Spells Known of 1st Level and Higher

You know two 1st-level spells of your choice from the ranger spell list.

The Spells Known column of the Ranger table shows when you learn more ranger spells of your choice. Each of these spells must be of a level for which you have spell slots. For instance, when you reach 5th level in this class, you can learn one new spell of 1st or 2nd level.

Additionally, when you gain a level in this class, you can choose one of the ranger spells you know and replace it with another spell from the ranger spell list, which also must be of a level for which you have spell slots.

#### Spellcasting Ability

Wisdom is your spellcasting ability for your ranger spells, since your magic draws on your attunement to nature. You use your Wisdom whenever a spell refers to your spellcasting ability. In addition, you use your Wisdom modifier when setting the saving throw DC for a ranger spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Wisdom modifier

**Spell attack modifier** = your proficiency bonus + your Wisdom modifier

### Ranger Archetype

At 3rd level, you choose an archetype that you strive to emulate: Hunter or Beast Master, both detailed at the end of the class description. Your choice grants you features at 3rd level and again at 7th, 11th, and 15th level.

### Primeval Awareness

Beginning at 3rd level, you can use your action and expend one ranger spell slot to focus your awareness on the region around you. For 1 minute per level of the spell slot you expend, you can sense whether the following types of creatures are present within 1 mile of you (or within up to 6 miles if you are in your favored terrain): aberrations, celestials, dragons, elementals, fey, fiends, and undead. This feature doesn't reveal the creatures' location or number.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Extra Attack

Beginning at 5th level, you can attack twice, instead of once, whenever you take the Attack action on your turn.

### Land's Stride

Starting at 8th level, moving through nonmagical difficult terrain costs you no extra movement. You can also pass through nonmagical plants without being slowed by them and without taking damage from them if they have thorns, spines, or a similar hazard.

In addition, you have advantage on saving throws against plants that are magically created or manipulated to impede movement, such those created by the *entangle* spell.

### Hide in Plain Sight

Starting at 10th level, you can spend 1 minute creating camouflage for yourself. You must have access to fresh mud, dirt, plants, soot, and other naturally occurring materials with which to create your camouflage.

Once you are camouflaged in this way, you can try to hide by pressing yourself up against a solid surface, such as a tree or wall, that is at least as tall and wide as you are. You gain a +10 bonus to Dexterity (Stealth) checks as long as you remain there without moving or taking actions. Once you move or take an action or a reaction, you must camouflage yourself again to gain this benefit.

### Vanish

Starting at 14th level, you can use the Hide action as a bonus action on your turn. Also, you can't be tracked by nonmagical means, unless you choose to leave a trail.

### Feral Senses

At 18th level, you gain preternatural senses that help you fight creatures you can't see. When you attack a creature you can't see, your inability to see it doesn't impose disadvantage on your attack rolls against it.

You are also aware of the location of any invisible creature within 30 feet of you, provided that the creature isn't hidden from you and you aren't blinded or deafened.

### Foe Slayer

At 20th level, you become an unparalleled hunter of your enemies. Once on each of your turns, you can add your Wisdom modifier to the attack roll or the damage roll of an attack you make against one of your favored enemies. You can choose to use this feature before or after the roll, but before any effects of the roll are applied.

## Ranger Archetypes

The ideal of the ranger has two classic expressions: the Hunter and the Beast Master.

### Hunter

Emulating the Hunter archetype means accepting your place as a bulwark between civilization and the terrors of the wilderness. As you walk the Hunter's path, you learn specialized techniques for fighting the threats you face, from rampaging ogres and hordes of orcs to towering giants and terrifying dragons.

#### Hunter's Prey

At 3rd level, you gain one of the following features of your choice.

***Colossus Slayer***. Your tenacity can wear down the most potent foes. When you hit a creature with a weapon attack, the creature takes an extra 1d8 damage if it's below its hit point maximum. You can deal this extra damage only once per turn.

***Giant Killer***. When a Large or larger creature within 5 feet of you hits or misses you with an attack, you can use your reaction to attack that creature immediately after its attack, provided that you can see the creature.

***Horde Breaker***. Once on each of your turns when you make a weapon attack, you can make another attack with the same weapon against a different creature that is within 5 feet of the original target and within range of your weapon.

#### Defensive Tactics

At 7th level, you gain one of the following features of your choice.

***Escape the Horde***. Opportunity attacks against you are made with disadvantage.

***Multiattack Defense***. When a creature hits you with an attack, you gain a +4 bonus to AC against all subsequent attacks made by that creature for the rest of the turn.

***Steel Will***. You have advantage on saving throws against being frightened.

#### Multiattack

At 11th level, you gain one of the following features of your choice.

***Volley***. You can use your action to make a ranged attack against any number of creatures within 10 feet of a point you can see within your weapon's range. You must have ammunition for each target, as normal, and you make a separate attack roll for each target.

***Whirlwind Attack***. You can use your action to make a melee attack against any number of creatures within 5 feet of you, with a separate attack roll for each target.

#### Superior Hunter's Defense

At 15th level, you gain one of the following features of your choice.

***Evasion***. When you are subjected to an effect, such as a red dragon's fiery breath or a *lightning bolt* spell, that allows you to make a Dexterity saving throw to take only half damage, you instead take no damage if you succeed on the saving throw, and only half damage if you fail.

***Stand Against the Tide***. When a hostile creature misses you with a melee attack, you can use your reaction to force that creature to repeat the same attack against another creature (other than itself) of your choice.

***Uncanny Dodge***. When an attacker that you can see hits you with an attack, you can use your reaction to halve the attack's damage against you.

## Rogue

### Class Features

As a rogue, you have the following class features.

#### Hit Points

**Hit Dice:** 1d8 per rogue level

**Hit Points at 1st Level:** 8 + your Constitution modifier

**Hit Points at Higher Levels:** 1d8 (or 5) + your Constitution modifier per rogue level after 1st

#### Proficiencies

**Armor:** Light armor

**Weapons:** Simple weapons, hand crossbows, longswords, rapiers, shortswords

**Tools:** Thieves' tools

**Saving Throws:** Dexterity, Intelligence

**Skills:** Choose four from Acrobatics, Athletics, Deception, Insight, Intimidation, Investigation, Perception, Performance, Persuasion, Sleight of Hand, and Stealth

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a rapier or (*b*) a shortsword
- (*a*) a shortbow and quiver of 20 arrows or (*b*) a shortsword
- (*a*) a burglar's pack, (*b*) a dungeoneer's pack, or (*c*) an explorer's pack
- Leather armor, two daggers, and thieves' tools

**Table- The Rogue**

| Level | Proficiency Bonus | Sneak Attack | Features                               |
|-------|-------------------|--------------|----------------------------------------|
| 1st   | +2                | 1d6          | Expertise, Sneak Attack, Thieves' Cant |
| 2nd   | +2                | 1d6          | Cunning Action                         |
| 3rd   | +2                | 2d6          | Roguish Archetype                      |
| 4th   | +2                | 2d6          | Ability Score Improvement              |
| 5th   | +3                | 3d6          | Uncanny Dodge                          |
| 6th   | +3                | 3d6          | Expertise                              |
| 7th   | +3                | 4d6          | Evasion                                |
| 8th   | +3                | 4d6          | Ability Score Improvement              |
| 9th   | +4                | 5d6          | Roguish Archetype feature              |
| 10th  | +4                | 5d6          | Ability Score Improvement              |
| 11th  | +4                | 6d6          | Reliable Talent                        |
| 12th  | +4                | 6d6          | Ability Score Improvement              |
| 13th  | +5                | 7d6          | Roguish Archetype Feature              |
| 14th  | +5                | 7d6          | Blindsense                             |
| 15th  | +5                | 8d6          | Slippery Mind                          |
| 16th  | +5                | 8d6          | Ability Score Improvement              |
| 17th  | +6                | 9d6          | Roguish Archetype Feature              |
| 18th  | +6                | 9d6          | Elusive                                |
| 19th  | +6                | 10d6         | Ability Score Improvement              |
| 20th  | +6                | 10d6         | Stroke of Luck                         |
|       |                   |              |                                        |

### Expertise

At 1st level, choose two of your skill proficiencies, or one of your skill proficiencies and your proficiency with thieves' tools. Your proficiency bonus is doubled for any ability check you make that uses either of the chosen proficiencies.

At 6th level, you can choose two more of your proficiencies (in skills or with thieves' tools) to gain this benefit.

### Sneak Attack

Beginning at 1st level, you know how to strike subtly and exploit a foe's distraction. Once per turn, you can deal an extra 1d6 damage to one creature you hit with an attack if you have advantage on the attack roll. The attack must use a finesse or a ranged weapon.

You don't need advantage on the attack roll if another enemy of the target is within 5 feet of it, that enemy isn't incapacitated, and you don't have disadvantage on the attack roll.

The amount of the extra damage increases as you gain levels in this class, as shown in the Sneak Attack column of the Rogue table.

### Thieves' Cant

During your rogue training you learned thieves' cant, a secret mix of dialect, jargon, and code that allows you to hide messages in seemingly normal conversation. Only another creature that knows thieves' cant understands such messages. It takes four times longer to convey such a message than it does to speak the same idea plainly.

In addition, you understand a set of secret signs and symbols used to convey short, simple messages, such as whether an area is dangerous or the territory of a thieves' guild, whether loot is nearby, or whether the people in an area are easy marks or will provide a safe house for thieves on the run.

### Cunning Action

Starting at 2nd level, your quick thinking and agility allow you to move and act quickly. You can take a bonus action on each of your turns in combat. This action can be used only to take the Dash, Disengage, or Hide action.

### Roguish Archetype

At 3rd level, you choose an archetype that you emulate in the exercise of your rogue abilities: Thief, Assassin, or Arcane Trickster, all detailed at the end of the class description. Your archetype choice grants you features at 3rd level and then again at 9th, 13th, and 17th level.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 10th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Uncanny Dodge

Starting at 5th level, when an attacker that you can see hits you with an attack, you can use your reaction to halve the attack's damage against you.

### Evasion

Beginning at 7th level, you can nimbly dodge out of the way of certain area effects, such as a red dragon's fiery breath or an *ice storm* spell. When you are subjected to an effect that allows you to make a Dexterity saving throw to take only half damage, you instead take no damage if you succeed on the saving throw, and only half damage if you fail.

### Reliable Talent

By 11th level, you have refined your chosen skills until they approach perfection. Whenever you make an ability check that lets you add your proficiency bonus, you can treat a d20 roll of 9 or lower as a 10.

### Blindsense

Starting at 14th level, if you are able to hear, you are aware of the location of any hidden or invisible creature within 10 feet of you.

### Slippery Mind

By 15th level, you have acquired greater mental strength. You gain proficiency in Wisdom saving throws.

### Elusive

Beginning at 18th level, you are so evasive that attackers rarely gain the upper hand against you. No attack roll has advantage against you while you aren't incapacitated.

### Stroke of Luck

At 20th level, you have an uncanny knack for succeeding when you need to. If your attack misses a target within range, you can turn the miss into a hit. Alternatively, if you fail an ability check, you can treat the d20 roll as a 20.

Once you use this feature, you can't use it again until you finish a short or long rest.

## Roguish Archetypes

Rogues have many features in common, including their emphasis on perfecting their skills, their precise and deadly approach to combat, and their increasingly quick reflexes. But different rogues steer those talents in varying directions, embodied by the rogue archetypes. Your choice of archetype is a reflection of your focus-not necessarily an indication of your chosen profession, but a description of your preferred techniques.

### Thief

You hone your skills in the larcenous arts. Burglars, bandits, cutpurses, and other criminals typically follow this archetype, but so do rogues who prefer to think of themselves as professional treasure seekers, explorers, delvers, and investigators. In addition to improving your agility and stealth, you learn skills useful for delving into ancient ruins, reading unfamiliar languages, and using magic items you normally couldn't employ.

#### Fast Hands

Starting at 3rd level, you can use the bonus action granted by your Cunning Action to make a Dexterity (Sleight of Hand) check, use your thieves' tools to disarm a trap or open a lock, or take the Use an Object action.

#### Second-Story Work

When you choose this archetype at 3rd level, you gain the ability to climb faster than normal; climbing no longer costs you extra movement.

In addition, when you make a running jump, the distance you cover increases by a number of feet equal to your Dexterity modifier.

#### Supreme Sneak

Starting at 9th level, you have advantage on a Dexterity (Stealth) check if you move no more than half your speed on the same turn.

#### Use Magic Device

By 13th level, you have learned enough about the workings of magic that you can improvise the use of items even when they are not intended for you. You ignore all class, race, and level requirements on the use of magic items.

#### Thief's Reflexes

When you reach 17th level, you have become adept at laying ambushes and quickly escaping danger. You can take two turns during the first round of any combat. You take your first turn at your normal initiative and your second turn at your initiative minus 10. You can't use this feature when you are surprised.

## Sorcerer

### Class Features

As a sorcerer, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d6 per sorcerer level

**Hit Points at 1st Level:** 6 + your Constitution modifier

**Hit Points at Higher Levels:** 1d6 (or 4) + your Constitution modifier per sorcerer level after 1st

#### Proficiencies

**Armor:** None

**Weapons:** Daggers, darts, slings, quarterstaffs, light crossbows

**Tools:** None

**Saving Throws:** Constitution, Charisma

**Skills:** Choose two from Arcana, Deception, Insight, Intimidation, Persuasion, and Religion

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a light crossbow and 20 bolts or (*b*) any simple weapon
- (*a*) a component pouch or (*b*) an arcane focus
- (*a*) a dungeoneer's pack or (*b*) an explorer's pack
- Two daggers

**Table- The Sorcerer**

| Level | Proficiency Bonus | Sorcery Points | Features                       | Cantrips Known | Spells Known | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
|-------|-------------------|----------------|--------------------------------|----------------|--------------|-----|-----|-----|-----|-----|-----|-----|-----|-----|
| 1st   | +2                | -              | Spellcasting, Sorcerous Origin | 4              | 2            | 2   | -   | -   | -   | -   | -   | -   | -   | -   |
| 2nd   | +2                | 2              | Font of Magic                  | 4              | 3            | 3   | -   | -   | -   | -   | -   | -   | -   | -   |
| 3rd   | +2                | 3              | Metamagic                      | 4              | 4            | 4   | 2   | -   | -   | -   | -   | -   | -   | -   |
| 4th   | +2                | 4              | Ability Score Improvement      | 5              | 5            | 4   | 3   | -   | -   | -   | -   | -   | -   | -   |
| 5th   | +3                | 5              | -                              | 5              | 6            | 4   | 3   | 2   | -   | -   | -   | -   | -   | -   |
| 6th   | +3                | 6              | Sorcerous Origin Feature       | 5              | 7            | 4   | 3   | 3   | -   | -   | -   | -   | -   | -   |
| 7th   | +3                | 7              | -                              | 5              | 8            | 4   | 3   | 3   | 1   | -   | -   | -   | -   | -   |
| 8th   | +3                | 8              | Ability Score Improvement      | 5              | 9            | 4   | 3   | 3   | 2   | -   | -   | -   | -   | -   |
| 9th   | +4                | 9              | -                              | 5              | 10           | 4   | 3   | 3   | 3   | 1   | -   | -   | -   | -   |
| 10th  | +4                | 10             | Metamagic                      | 6              | 11           | 4   | 3   | 3   | 3   | 2   | -   | -   | -   | -   |
| 11th  | +4                | 11             | -                              | 6              | 12           | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 12th  | +4                | 12             | Ability Score Improvement      | 6              | 12           | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 13th  | +5                | 13             | -                              | 6              | 13           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 14th  | +5                | 14             | Sorcerous Origin Feature       | 6              | 13           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 15th  | +5                | 15             | -                              | 6              | 14           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 16th  | +5                | 16             | Ability Score Improvement      | 6              | 14           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 17th  | +6                | 17             | Metamagic                      | 6              | 15           | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | 1   |
| 18th  | +6                | 18             | Sorcerous Origin Feature       | 6              | 15           | 4   | 3   | 3   | 3   | 3   | 1   | 1   | 1   | 1   |
| 19th  | +6                | 19             | Ability Score Improvement      | 6              | 15           | 4   | 3   | 3   | 3   | 3   | 2   | 1   | 1   | 1   |
| 20th  | +6                | 20             | Sorcerous Restoration          | 6              | 15           | 4   | 3   | 3   | 3   | 3   | 2   | 2   | 1   | 1   |
|       |                   |                |                                |                |              |     |     |     |     |     |     |     |     |     |

### Spellcasting

An event in your past, or in the life of a parent or ancestor, left an indelible mark on you, infusing you with arcane magic. This font of magic, whatever its origin, fuels your spells.

#### Cantrips

At 1st level, you know four cantrips of your choice from the sorcerer spell list. You learn additional sorcerer cantrips of your choice at higher levels, as shown in the Cantrips Known column of the Sorcerer table.

#### Spell Slots

The Sorcerer table shows how many spell slots you have to cast your sorcerer spells of 1st level and higher. To cast one of these sorcerer spells, you must expend a slot of the spell's level or higher. You regain all expended spell slots when you finish a long rest.

For example, if you know the 1st-level spell *burning hands* and have a 1st-level and a 2nd-level spell slot available, you can cast *burning hands* using either slot.

#### Spells Known of 1st Level and Higher

You know two 1st-level spells of your choice from the sorcerer spell list.

The Spells Known column of the Sorcerer table shows when you learn more sorcerer spells of your choice. Each of these spells must be of a level for which you have spell slots. For instance, when you reach 3rd level in this class, you can learn one new spell of 1st or 2nd level.

Additionally, when you gain a level in this class, you can choose one of the sorcerer spells you know and replace it with another spell from the sorcerer spell list, which also must be of a level for which you have spell slots.

#### Spellcasting Ability

Charisma is your spellcasting ability for your sorcerer spells, since the power of your magic relies on your ability to project your will into the world. You use your Charisma whenever a spell refers to your spellcasting ability. In addition, you use your Charisma modifier when setting the saving throw DC for a sorcerer spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Charisma modifier

**Spell attack modifier** = your proficiency bonus + your Charisma modifier

#### Spellcasting Focus

You can use an arcane focus as a spellcasting focus for your sorcerer spells.

### Sorcerous Origin

Choose a sorcerous origin, which describes the source of your innate magical power: Draconic Bloodline or Wild Magic, both detailed at the end of the class description.

Your choice grants you features when you choose it at 1st level and again at 6th, 14th, and 18th level.

### Font of Magic

At 2nd level, you tap into a deep wellspring of magic within yourself. This wellspring is represented by sorcery points, which allow you to create a variety of magical effects.

#### Sorcery Points

You have 2 sorcery points, and you gain more as you reach higher levels, as shown in the Sorcery Points column of the Sorcerer table. You can never have more sorcery points than shown on the table for your level. You regain all spent sorcery points when you finish a long rest.

#### Flexible Casting

You can use your sorcery points to gain additional spell slots, or sacrifice spell slots to gain additional sorcery points. You learn other ways to use your sorcery points as you reach higher levels. Any spell slot you create with this feature vanishes when you finish a long rest.

***Creating Spell Slots***. You can transform unexpended sorcery points into one spell slot as a bonus action on your turn. The Creating Spell Slots table shows the cost of creating a spell slot of a given level. You can create spell slots no higher in level than 5th.

Any spell slot you create with this feature vanishes when you finish a long rest.

**Table- Creating Spell Slots**

| Spell Slot Level | Sorcery Point Cost |
|------------------|--------------------|
| 1st              | 2                  |
| 2nd              | 3                  |
| 3rd              | 5                  |
| 4th              | 6                  |
| 5th              | 7                  |
|                  |                    |

***Converting a Spell Slot to Sorcery Points***. As a bonus action on your turn, you can expend one spell slot and gain a number of sorcery points equal to the slot's level.

### Metamagic

At 3rd level, you gain the ability to twist your spells to suit your needs. You gain two of the following Metamagic options of your choice. You gain another one at 10th and 17th level.

You can use only one Metamagic option on a spell when you cast it, unless otherwise noted.

#### Careful Spell

When you cast a spell that forces other creatures to make a saving throw, you can protect some of those creatures from the spell's full force. To do so, you spend 1 sorcery point and choose a number of those creatures up to your Charisma modifier (minimum of one creature). A chosen creature automatically succeeds on its saving throw against the spell.

#### Distant Spell

When you cast a spell that has a range of 5 feet or greater, you can spend 1 sorcery point to double the range of the spell.

When you cast a spell that has a range of touch, you can spend 1 sorcery point to make the range of the spell 30 feet.

#### Empowered Spell

When you roll damage for a spell, you can spend 1 sorcery point to reroll a number of the damage dice up to your Charisma modifier (minimum of one). You must use the new rolls.

You can use Empowered Spell even if you have already used a different Metamagic option during the casting of the spell.

#### Extended Spell

When you cast a spell that has a duration of 1 minute or longer, you can spend 1 sorcery point to double its duration, to a maximum duration of 24 hours.

#### Heightened Spell

When you cast a spell that forces a creature to make a saving throw to resist its effects, you can spend 3 sorcery points to give one target of the spell disadvantage on its first saving throw made against the spell.

#### Quickened Spell

When you cast a spell that has a casting time of 1 action, you can spend 2 sorcery points to change the casting time to 1 bonus action for this casting.

#### Subtle Spell

When you cast a spell, you can spend 1 sorcery point to cast it without any somatic or verbal components.

#### Twinned Spell

When you cast a spell that targets only one creature and doesn't have a range of self, you can spend a number of sorcery points equal to the spell's level to target a second creature in range with the same spell (1 sorcery point if the spell is a cantrip).

To be eligible, a spell must be incapable of targeting more than one creature at the spell's current level. For example, *magic missile* and *scorching ray* aren't eligible, but *ray of frost* and *chromatic orb* are.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Sorcerous Restoration

At 20th level, you regain 4 expended sorcery points whenever you finish a short rest.

## Sorcerous Origins

Different sorcerers claim different origins for their innate magic. Although many variations exist, most of these origins fall into two categories: a draconic bloodline and wild magic.

### Draconic Bloodline

Your innate magic comes from draconic magic that was mingled with your blood or that of your ancestors. Most often, sorcerers with this origin trace their descent back to a mighty sorcerer of ancient times who made a bargain with a dragon or who might even have claimed a dragon parent. Some of these bloodlines are well established in the world, but most are obscure. Any given sorcerer could be the first of a new bloodline, as a result of a pact or some other exceptional circumstance.

#### Dragon Ancestor

At 1st level, you choose one type of dragon as your ancestor. The damage type associated with each dragon is used by features you gain later.

**Table- Draconic Ancestry**

| Dragon | Damage Type |
|--------|-------------|
| Black  | Acid        |
| Blue   | Lightning   |
| Brass  | Fire        |
| Bronze | Lightning   |
| Copper | Acid        |
| Gold   | Fire        |
| Green  | Poison      |
| Red    | Fire        |
| Silver | Cold        |
| White  | Cold        |
|        |             |

You can speak, read, and write Draconic. Additionally, whenever you make a Charisma check when interacting with dragons, your proficiency bonus is doubled if it applies to the check.

#### Draconic Resilience

As magic flows through your body, it causes physical traits of your dragon ancestors to emerge. At 1st level, your hit point maximum increases by 1 and increases by 1 again whenever you gain a level in this class.

Additionally, parts of your skin are covered by a thin sheen of dragon-like scales. When you aren't wearing armor, your AC equals 13 + your Dexterity modifier.

#### Elemental Affinity

Starting at 6th level, when you cast a spell that deals damage of the type associated with your draconic ancestry, you can add your Charisma modifier to one damage roll of that spell. At the same time, you can spend 1 sorcery point to gain resistance to that damage type for 1 hour.

#### Dragon Wings

At 14th level, you gain the ability to sprout a pair of dragon wings from your back, gaining a flying speed equal to your current speed. You can create these wings as a bonus action on your turn. They last until you dismiss them as a bonus action on your turn.

You can't manifest your wings while wearing armor unless the armor is made to accommodate them, and clothing not made to accommodate your wings might be destroyed when you manifest them.

#### Draconic Presence

Beginning at 18th level, you can channel the dread presence of your dragon ancestor, causing those around you to become awestruck or frightened. As an action, you can spend 5 sorcery points to draw on this power and exude an aura of awe or fear (your choice) to a distance of 60 feet. For 1 minute or until you lose your concentration (as if you were casting a concentration spell), each hostile creature that starts its turn in this aura must succeed on a Wisdom saving throw or be charmed (if you chose awe) or frightened (if you chose fear) until the aura ends. A creature that succeeds on this saving throw is immune to your aura for 24 hours.

## Warlock

### Class Features

As a warlock, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d8 per warlock level

**Hit Points at 1st Level:** 8 + your Constitution modifier

**Hit Points at Higher Levels:** 1d8 (or 5) + your Constitution modifier per warlock level after 1st

#### Proficiencies

**Armor:** Light armor

**Weapons:** Simple weapons

**Tools:** None

**Saving Throws:** Wisdom, Charisma

**Skills:** Choose two skills from Arcana, Deception, History, Intimidation, Investigation, Nature, and Religion

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a light crossbow and 20 bolts or (*b*) any simple weapon
- (*a*) a component pouch or (*b*) an arcane focus
- (*a*) a scholar's pack or (*b*) a dungeoneer's pack
- Leather armor, any simple weapon, and two daggers

**Table- The Warlock**

| Level | Proficiency Bonus | Features                        | Cantrips Known | Spells Known | Spell Slots | Slot Level | Invocations Known |
|-------|-------------------|---------------------------------|----------------|--------------|-------------|------------|-------------------|
| 1st   | +2                | Otherworldly Patron, Pact Magic | 2              | 2            | 1           | 1st        | -                 |
| 2nd   | +2                | Eldritch Invocations            | 2              | 3            | 2           | 1st        | 2                 |
| 3rd   | +2                | Pact Boon                       | 2              | 4            | 2           | 2nd        | 2                 |
| 4th   | +2                | Ability Score Improvement       | 3              | 5            | 2           | 2nd        | 2                 |
| 5th   | +3                | -                               | 3              | 6            | 2           | 3rd        | 3                 |
| 6th   | +3                | Otherworldly Patron feature     | 3              | 7            | 2           | 3rd        | 3                 |
| 7th   | +3                | -                               | 3              | 8            | 2           | 4th        | 4                 |
| 8th   | +3                | Ability Score Improvement       | 3              | 9            | 2           | 4th        | 4                 |
| 9th   | +4                | -                               | 3              | 10           | 2           | 5th        | 5                 |
| 10th  | +4                | Otherworldly Patron feature     | 4              | 10           | 2           | 5th        | 5                 |
| 11th  | +4                | Mystic Arcanum (6th level)      | 4              | 11           | 3           | 5th        | 5                 |
| 12th  | +4                | Ability Score Improvement       | 4              | 11           | 3           | 5th        | 6                 |
| 13th  | +5                | Mystic Arcanum (7th level)      | 4              | 12           | 3           | 5th        | 6                 |
| 14th  | +5                | Otherworldly Patron feature     | 4              | 12           | 3           | 5th        | 6                 |
| 15th  | +5                | Mystic Arcanum (8th level)      | 4              | 13           | 3           | 5th        | 7                 |
| 16th  | +5                | Ability Score Improvement       | 4              | 13           | 3           | 5th        | 7                 |
| 17th  | +6                | Mystic Arcanum (9th level)      | 4              | 14           | 4           | 5th        | 7                 |
| 18th  | +6                | -                               | 4              | 14           | 4           | 5th        | 8                 |
| 19th  | +6                | Ability Score Improvement       | 4              | 15           | 4           | 5th        | 8                 |
| 20th  | +6                | Eldritch Master                 | 4              | 15           | 4           | 5th        | 8                 |
|       |                   |                                 |                |              |             |            |                   |

### Otherworldly Patron

At 1st level, you have struck a bargain with an otherworldly being of your choice: the Archfey, the Fiend, or the Great Old One, each of which is detailed at the end of the class description. Your choice grants you features at 1st level and again at 6th, 10th, and 14th level.

### Pact Magic

Your arcane research and the magic bestowed on you by your patron have given you facility with spells.

#### Cantrips

You know two cantrips of your choice from the warlock spell list. You learn additional warlock cantrips of your choice at higher levels, as shown in the Cantrips Known column of the Warlock table.

#### Spell Slots

The Warlock table shows how many spell slots you have to cast your warlock spells of 1st through 5th level. The table also shows what the level of those slots is; all of your spell slots are the same level. To cast one of your warlock spells of 1st level or higher, you must expend a spell slot. You regain all expended spell slots when you finish a short or long rest.

For example, when you are 5th level, you have two 3rd-level spell slots. To cast the 1st-level spell *witch bolt*, you must spend one of those slots, and you cast it as a 3rd-level spell.

#### Spells Known of 1st Level and Higher

At 1st level, you know two 1st-level spells of your choice from the warlock spell list.

The Spells Known column of the Warlock table shows when you learn more warlock spells of your choice of 1st level and higher. A spell you choose must be of a level no higher than what's shown in the table's Slot Level column for your level. When you reach 6th level, for example, you learn a new warlock spell, which can be 1st, 2nd, or 3rd level.

Additionally, when you gain a level in this class, you can choose one of the warlock spells you know and replace it with another spell from the warlock spell list, which also must be of a level for which you have spell slots.

#### Spellcasting Ability

Charisma is your spellcasting ability for your warlock spells, so you use your Charisma whenever a spell refers to your spellcasting ability. In addition, you use your Charisma modifier when setting the saving throw DC for a warlock spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Charisma modifier

**Spell attack modifier** = your proficiency bonus + your Charisma modifier

#### Spellcasting Focus

You can use an arcane focus as a spellcasting focus for your warlock spells.

### Eldritch Invocations

In your study of occult lore, you have unearthed eldritch invocations, fragments of forbidden knowledge that imbue you with an abiding magical ability.

At 2nd level, you gain two eldritch invocations of your choice. Your invocation options are detailed at the end of the class description. When you gain certain warlock levels, you gain additional invocations of your choice, as shown in the Invocations Known column of the Warlock table.

Additionally, when you gain a level in this class, you can choose one of the invocations you know and replace it with another invocation that you could learn at that level.

### Pact Boon

At 3rd level, your otherworldly patron bestows a gift upon you for your loyal service. You gain one of the following features of your choice.

#### Pact of the Chain

You learn the *find familiar* spell and can cast it as a ritual. The spell doesn't count against your number of spells known.

When you cast the spell, you can choose one of the normal forms for your familiar or one of the following special forms: imp, pseudodragon, quasit, or sprite.

Additionally, when you take the Attack action, you can forgo one of your own attacks to allow your familiar to make one attack with its reaction.

#### Pact of the Blade

You can use your action to create a pact weapon in your empty hand. You can choose the form that this melee weapon takes each time you create it. You are proficient with it while you wield it. This weapon counts as magical for the purpose of overcoming resistance and immunity to nonmagical attacks and damage.

Your pact weapon disappears if it is more than 5 feet away from you for 1 minute or more. It also disappears if you use this feature again, if you dismiss the weapon (no action required), or if you die.

You can transform one magic weapon into your pact weapon by performing a special ritual while you hold the weapon. You perform the ritual over the course of 1 hour, which can be done during a short rest. You can then dismiss the weapon, shunting it into an extradimensional space, and it appears whenever you create your pact weapon thereafter. You can't affect an artifact or a sentient weapon in this way. The weapon ceases being your pact weapon if you die, if you perform the 1-hour ritual on a different weapon, or if you use a 1-hour ritual to break your bond to it. The weapon appears at your feet if it is in the extradimensional space when the bond breaks.

#### Pact of the Tome

Your patron gives you a grimoire called a Book of Shadows. When you gain this feature, choose three cantrips from any class's spell list (the three needn't be from the same list). While the book is on your person, you can cast those cantrips at will. They don't count against your number of cantrips known. If they don't appear on the warlock spell list, they are nonetheless warlock spells for you.

If you lose your Book of Shadows, you can perform a 1-hour ceremony to receive a replacement from your patron. This ceremony can be performed during a short or long rest, and it destroys the previous book. The book turns to ash when you die.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Mystic Arcanum

At 11th level, your patron bestows upon you a magical secret called an arcanum. Choose one 6th- level spell from the warlock spell list as this arcanum.

You can cast your arcanum spell once without expending a spell slot. You must finish a long rest before you can do so again.

At higher levels, you gain more warlock spells of your choice that can be cast in this way: one 7th- level spell at 13th level, one 8th-level spell at 15th level, and one 9th-level spell at 17th level. You regain all uses of your Mystic Arcanum when you finish a long rest.

### Eldritch Master

At 20th level, you can draw on your inner reserve of mystical power while entreating your patron to regain expended spell slots. You can spend 1 minute entreating your patron for aid to regain all your expended spell slots from your Pact Magic feature. Once you regain spell slots with this feature, you must finish a long rest before you can do so again.

### Eldritch Invocations

If an eldritch invocation has prerequisites, you must meet them to learn it. You can learn the invocation at the same time that you meet its prerequisites. A level prerequisite refers to your level in this class.

#### Agonizing Blast

*Prerequisite: Eldritch Blast cantrip*

When you cast *eldritch blast*, add your Charisma modifier to the damage it deals on a hit.

#### Armor of Shadows

You can cast *mage armor* on yourself at will, without expending a spell slot or material components.

#### Ascendant Step

*Prerequisite: 9th level*

You can cast *levitate* on yourself at will, without expending a spell slot or material components.

#### Beast Speech

You can cast *speak with animals* at will, without expending a spell slot.

#### Beguiling Influence

You gain proficiency in the Deception and Persuasion skills.

#### Bewitching Whispers

*Prerequisite: 7th level*

You can cast *compulsion* once using a warlock spell slot. You can't do so again until you finish a long rest.

#### Book of Ancient Secrets

*Prerequisite: Pact of the Tome feature*

You can now inscribe magical rituals in your Book of Shadows. Choose two 1st-level spells that have the ritual tag from any class's spell list (the two needn't be from the same list). The spells appear in the book and don't count against the number of spells you know. With your Book of Shadows in hand, you can cast the chosen spells as rituals. You can't cast the spells except as rituals, unless you've learned them by some other means. You can also cast a warlock spell you know as a ritual if it has the ritual tag.

On your adventures, you can add other ritual spells to your Book of Shadows. When you find such a spell, you can add it to the book if the spell's level is equal to or less than half your warlock level (rounded up) and if you can spare the time to transcribe the spell. For each level of the spell, the transcription process takes 2 hours and costs 50 gp for the rare inks needed to inscribe it.

#### Chains of Carceri

*Prerequisite: 15th level, Pact of the Chain feature*

You can cast *hold monster* at will-targeting a celestial, fiend, or elemental-without expending a spell slot or material components. You must finish a long rest before you can use this invocation on the same creature again.

#### Devil's Sight

You can see normally in darkness, both magical and nonmagical, to a distance of 120 feet.

#### Dreadful Word

*Prerequisite: 7th level*

You can cast *confusion* once using a warlock spell slot. You can't do so again until you finish a long rest.

#### Eldritch Sight

You can cast *detect magic* at will, without expending a spell slot.

#### Eldritch Spear

*Prerequisite: Eldritch Blast cantrip*

When you cast *eldritch blast*, its range is 300 feet.

#### Eyes of the Rune Keeper

You can read all writing.

#### Fiendish Vigor

You can cast *false life* on yourself at will as a 1st-level spell, without expending a spell slot or material components.

#### Gaze of Two Minds

You can use your action to touch a willing humanoid and perceive through its senses until the end of your next turn. As long as the creature is on the same plane of existence as you, you can use your action on subsequent turns to maintain this connection, extending the duration until the end of your next turn. While perceiving through the other creature's senses, you benefit from any special senses possessed by that creature, and you are blinded and deafened to your own surroundings.

#### Lifedrinker

*Prerequisite: 12th level, Pact of the Blade feature*

When you hit a creature with your pact weapon, the creature takes extra necrotic damage equal to your Charisma modifier (minimum 1).

#### Mask of Many Faces

You can cast *disguise self* at will, without expending a spell slot.

#### Master of Myriad Forms

*Prerequisite: 15th level*

You can cast *alter self* at will, without expending a spell slot.

#### Minions of Chaos

*Prerequisite: 9th level*

You can cast *conjure elemental* once using a warlock spell slot. You can't do so again until you finish a long rest.

#### Mire the Mind

*Prerequisite: 5th level*

You can cast *slow* once using a warlock spell slot. You can't do so again until you finish a long rest.

#### Misty Visions

You can cast *silent image* at will, without expending a spell slot or material components.

#### One with Shadows

*Prerequisite: 5th level*

When you are in an area of dim light or darkness, you can use your action to become invisible until you move or take an action or a reaction.

#### Otherworldly Leap

*Prerequisite: 9th level*

You can cast *jump* on yourself at will, without expending a spell slot or material components.

#### Repelling Blast

*Prerequisite: Eldritch Blast cantrip*

When you hit a creature with *eldritch blast*, you can push the creature up to 10 feet away from you in a straight line.

#### Sculptor of Flesh

*Prerequisite: 7th level*

You can cast *polymorph* once using a warlock spell slot. You can't do so again until you finish a long rest.

#### Sign of Ill Omen

*Prerequisite: 5th level*

You can cast *bestow curse* once using a warlock spell slot. You can't do so again until you finish a long rest.

#### Thief of Five Fates

You can cast *bane* once using a warlock spell slot. You can't do so again until you finish a long rest.

#### Thirsting Blade

*Prerequisite: 5th level, Pact of the Blade feature*

You can attack with your pact weapon twice, instead of once, whenever you take the Attack action on your turn.

#### Visions of Distant Realms

*Prerequisite: 15th level*

You can cast *arcane eye* at will, without expending a spell slot.

#### Voice of the Chain Master

*Prerequisite: Pact of the Chain feature*

You can communicate telepathically with your familiar and perceive through your familiar's senses as long as you are on the same plane of existence. Additionally, while perceiving through your familiar's senses, you can also speak through your familiar in your own voice, even if your familiar is normally incapable of speech.

#### Whispers of the Grave

*Prerequisite: 9th level*

You can cast *speak with dead* at will, without expending a spell slot.

#### Witch Sight

*Prerequisite: 15th level*

You can see the true form of any shapechanger or creature concealed by illusion or transmutation magic while the creature is within 30 feet of you and within line of sight.

## Otherworldly Patrons

The beings that serve as patrons for warlocks are mighty inhabitants of other planes of existence-not gods, but almost godlike in their power. Various patrons give their warlocks access to different powers and invocations, and expect significant favors in return.

Some patrons collect warlocks, doling out mystic knowledge relatively freely or boasting of their ability to bind mortals to their will. Other patrons bestow their power only grudgingly, and might make a pact with only one warlock. Warlocks who serve the same patron might view each other as allies, siblings, or rivals.

### The Fiend

You have made a pact with a fiend from the lower planes of existence, a being whose aims are evil, even if you strive against those aims. Such beings desire the corruption or destruction of all things, ultimately including you. Fiends powerful enough to forge a pact include demon lords such as Demogorgon, Orcus, Fraz'Urb-luu, and Baphomet; archdevils such as Asmodeus, Dispater, Mephistopheles, and Belial; pit fiends and balors that are especially mighty; and ultroloths and other lords of the yugoloths.

#### Expanded Spell List

The Fiend lets you choose from an expanded list of spells when you learn a warlock spell. The following spells are added to the warlock spell list for you.

**Table- Fiend Expanded Spells**

| Spell Level | Spells                            |
|-------------|-----------------------------------|
| 1st         | burning hands, command            |
| 2nd         | blindness/deafness, scorching ray |
| 3rd         | fireball, stinking cloud          |
| 4th         | fire shield, wall of fire         |
| 5th         | flame strike, hallow              |
|             |                                   |

#### Dark One's Blessing

Starting at 1st level, when you reduce a hostile creature to 0 hit points, you gain temporary hit points equal to your Charisma modifier + your warlock level (minimum of 1).

#### Dark One's Own Luck

Starting at 6th level, you can call on your patron to alter fate in your favor. When you make an ability check or a saving throw, you can use this feature to add a d10 to your roll. You can do so after seeing the initial roll but before any of the roll's effects occur.

Once you use this feature, you can't use it again until you finish a short or long rest.

#### Fiendish Resilience

Starting at 10th level, you can choose one damage type when you finish a short or long rest. You gain resistance to that damage type until you choose a different one with this feature. Damage from magical weapons or silver weapons ignores this resistance.

#### Hurl Through Hell

Starting at 14th level, when you hit a creature with an attack, you can use this feature to instantly transport the target through the lower planes. The creature disappears and hurtles through a nightmare landscape.

At the end of your next turn, the target returns to the space it previously occupied, or the nearest unoccupied space. If the target is not a fiend, it takes 10d10 psychic damage as it reels from its horrific experience.

Once you use this feature, you can't use it again until you finish a long rest.

**Your Pact Boon**

Each Pact Boon option produces a special creature or an object that reflects your patron's nature.

***Pact of the Chain***. Your familiar is more cunning than a typical familiar. Its default form can be a reflection of your patron, with sprites and pseudodragons tied to the Archfey and imps and quasits tied to the Fiend. Because the Great Old One's nature is inscrutable, any familiar form is suitable for it.

***Pact of the Blade***. If your patron is the Archfey, your weapon might be a slender blade wrapped in leafy vines. If you serve the Fiend, your weapon could be an axe made of black metal and adorned with decorative flames. If your patron is the Great Old One, your weapon might be an ancient-looking spear, with a gemstone embedded in its head, carved to look like a terrible unblinking eye.

***Pact of the Tome***. Your Book of Shadows might be a fine, gilt-edged tome with spells of enchantment and illusion, gifted to you by the lordly Archfey. It could be a weighty tome bound in demon hide studded with iron, holding spells of conjuration and a wealth of forbidden lore about the sinister regions of the cosmos, a gift of the Fiend. Or it could be the tattered diary of a lunatic driven mad by contact with the Great Old One, holding scraps of spells that only your own burgeoning insanity allows you to understand and cast.

## Wizard

### Class Features

As a wizard, you gain the following class features.

#### Hit Points

**Hit Dice:** 1d6 per wizard level

**Hit Points at 1st Level:** 6 + your Constitution modifier

**Hit Points at Higher Levels:** 1d6 (or 4) + your Constitution modifier per wizard level after 1st

#### Proficiencies

**Armor:** None

**Weapons:** Daggers, darts, slings, quarterstaffs, light crossbows

**Tools:** None

**Saving Throws:** Intelligence, Wisdom

**Skills:** Choose two from Arcana, History, Insight, Investigation, Medicine, and Religion

#### Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (*a*) a quarterstaff or (*b*) a dagger
- (*a*) a component pouch or (*b*) an arcane focus
- (*a*) a scholar's pack or (*b*) an explorer's pack
- A spellbook

**Table- The Wizard**

| Level | Proficiency Bonus | Features                      | Cantrips Known | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
|-------|-------------------|-------------------------------|----------------|-----|-----|-----|-----|-----|-----|-----|-----|-----|
| 1st   | +2                | Spellcasting, Arcane Recovery | 3              | 2   | -   | -   | -   | -   | -   | -   | -   | -   |
| 2nd   | +2                | Arcane Tradition              | 3              | 3   | -   | -   | -   | -   | -   | -   | -   | -   |
| 3rd   | +2                | -                             | 3              | 4   | 2   | -   | -   | -   | -   | -   | -   | -   |
| 4th   | +2                | Ability Score Improvement     | 4              | 4   | 3   | -   | -   | -   | -   | -   | -   | -   |
| 5th   | +3                | -                             | 4              | 4   | 3   | 2   | -   | -   | -   | -   | -   | -   |
| 6th   | +3                | Arcane Tradition Feature      | 4              | 4   | 3   | 3   | -   | -   | -   | -   | -   | -   |
| 7th   | +3                | -                             | 4              | 4   | 3   | 3   | 1   | -   | -   | -   | -   | -   |
| 8th   | +3                | Ability Score Improvement     | 4              | 4   | 3   | 3   | 2   | -   | -   | -   | -   | -   |
| 9th   | +4                | -                             | 4              | 4   | 3   | 3   | 3   | 1   | -   | -   | -   | -   |
| 10th  | +4                | Arcane Tradition Feature      | 5              | 4   | 3   | 3   | 3   | 2   | -   | -   | -   | -   |
| 11th  | +4                | -                             | 5              | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 12th  | +4                | Ability Score Improvement     | 5              | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 13th  | +5                | -                             | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 14th  | +5                | Arcane Tradition Feature      | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 15th  | +5                | -                             | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 16th  | +5                | Ability Score Improvement     | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 17th  | +6                | -                             | 5              | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | 1   |
| 18th  | +6                | Spell Mastery                 | 5              | 4   | 3   | 3   | 3   | 3   | 1   | 1   | 1   | 1   |
| 19th  | +6                | Ability Score Improvement     | 5              | 4   | 3   | 3   | 3   | 3   | 2   | 1   | 1   | 1   |
| 20th  | +6                | Signature Spell               | 5              | 4   | 3   | 3   | 3   | 3   | 2   | 2   | 1   | 1   |
|       |                   |                               |                |     |     |     |     |     |     |     |     |     |

### Spellcasting

As a student of arcane magic, you have a spellbook containing spells that show the first glimmerings of your true power.

#### Cantrips

At 1st level, you know three cantrips of your choice from the wizard spell list. You learn additional wizard cantrips of your choice at higher levels, as shown in the Cantrips Known column of the Wizard table.

#### Spellbook

At 1st level, you have a spellbook containing six 1st- level wizard spells of your choice. Your spellbook is the repository of the wizard spells you know, except your cantrips, which are fixed in your mind.

#### Preparing and Casting Spells

The Wizard table shows how many spell slots you have to cast your wizard spells of 1st level and higher. To cast one of these spells, you must expend a slot of the spell's level or higher. You regain all expended spell slots when you finish a long rest.

You prepare the list of wizard spells that are available for you to cast. To do so, choose a number of wizard spells from your spellbook equal to your Intelligence modifier + your wizard level (minimum of one spell). The spells must be of a level for which you have spell slots.

For example, if you're a 3rd-level wizard, you have four 1st-level and two 2nd-level spell slots. With an Intelligence of 16, your list of prepared spells can include six spells of 1st or 2nd level, in any combination, chosen from your spellbook. If you prepare the 1st-level spell *magic missile*, you can cast it using a 1st-level or a 2nd-level slot. Casting the spell doesn't remove it from your list of prepared spells.

You can change your list of prepared spells when you finish a long rest. Preparing a new list of wizard spells requires time spent studying your spellbook and memorizing the incantations and gestures you must make to cast the spell: at least 1 minute per spell level for each spell on your list.

#### Spellcasting Ability

Intelligence is your spellcasting ability for your wizard spells, since you learn your spells through dedicated study and memorization. You use your Intelligence whenever a spell refers to your spellcasting ability. In addition, you use your Intelligence modifier when setting the saving throw DC for a wizard spell you cast and when making an attack roll with one.

**Spell save DC** = 8 + your proficiency bonus + your Intelligence modifier

**Spell attack modifier** = your proficiency bonus + your Intelligence modifier

#### Ritual Casting

You can cast a wizard spell as a ritual if that spell has the ritual tag and you have the spell in your spellbook. You don't need to have the spell prepared.

#### Spellcasting Focus

You can use an arcane focus as a spellcasting focus for your wizard spells.

#### Learning Spells of 1st Level and Higher

Each time you gain a wizard level, you can add two wizard spells of your choice to your spellbook for free. Each of these spells must be of a level for which you have spell slots, as shown on the Wizard table. On your adventures, you might find other spells that you can add to your spellbook.

### Arcane Recovery

You have learned to regain some of your magical energy by studying your spellbook. Once per day when you finish a short rest, you can choose expended spell slots to recover. The spell slots can have a combined level that is equal to or less than half your wizard level (rounded up), and none of the slots can be 6th level or higher.

For example, if you're a 4th-level wizard, you can recover up to two levels worth of spell slots. You can recover either a 2nd-level spell slot or two 1st-level spell slots.

### Arcane Tradition

When you reach 2nd level, you choose an arcane tradition, shaping your practice of magic through one of eight schools: Abjuration, Conjuration, Divination, Enchantment, Evocation, Illusion, Necromancy, or Transmutation, all detailed at the end of the class description.

Your choice grants you features at 2nd level and again at 6th, 10th, and 14th level.

### Ability Score Improvement

When you reach 4th level, and again at 8th, 12th, 16th, and 19th level, you can increase one ability score of your choice by 2, or you can increase two ability scores of your choice by 1. As normal, you can't increase an ability score above 20 using this feature.

### Spell Mastery

At 18th level, you have achieved such mastery over certain spells that you can cast them at will. Choose a 1st-level wizard spell and a 2nd-level wizard spell that are in your spellbook. You can cast those spells at their lowest level without expending a spell slot when you have them prepared. If you want to cast either spell at a higher level, you must expend a spell slot as normal.

By spending 8 hours in study, you can exchange one or both of the spells you chose for different spells of the same levels.

### Signature Spells

When you reach 20th level, you gain mastery over two powerful spells and can cast them with little effort. Choose two 3rd-level wizard spells in your spellbook as your signature spells. You always have these spells prepared, they don't count against the number of spells you have prepared, and you can cast each of them once at 3rd level without expending a spell slot. When you do so, you can't do so again until you finish a short or long rest.

If you want to cast either spell at a higher level, you must expend a spell slot as normal.

## Arcane Traditions

The study of wizardry is ancient, stretching back to the earliest mortal discoveries of magic. It is firmly established in fantasy gaming worlds, with various traditions dedicated to its complex study.

The most common arcane traditions in the multiverse revolve around the schools of magic. Wizards through the ages have cataloged thousands of spells, grouping them into eight categories called schools. In some places, these traditions are literally schools; a wizard might study at the School of Illusion while another studies across town at the School of Enchantment. In other institutions, the schools are more like academic departments, with rival faculties competing for students and funding. Even wizards who train apprentices in the solitude of their own towers use the division of magic into schools as a learning device, since the spells of each school require mastery of different techniques.

### School of Evocation

You focus your study on magic that creates powerful elemental effects such as bitter cold, searing flame, rolling thunder, crackling lightning, and burning acid. Some evokers find employment in military forces, serving as artillery to blast enemy armies from afar. Others use their spectacular power to protect the weak, while some seek their own gain as bandits, adventurers, or aspiring tyrants.

#### Evocation Savant

Beginning when you select this school at 2nd level, the gold and time you must spend to copy an evocation spell into your spellbook is halved.

#### Sculpt Spells

Beginning at 2nd level, you can create pockets of relative safety within the effects of your evocation spells. When you cast an evocation spell that affects other creatures that you can see, you can choose a number of them equal to 1 + the spell's level. The chosen creatures automatically succeed on their saving throws against the spell, and they take no damage if they would normally take half damage on a successful save.

#### Potent Cantrip

Starting at 6th level, your damaging cantrips affect even creatures that avoid the brunt of the effect. When a creature succeeds on a saving throw against your cantrip, the creature takes half the cantrip's damage (if any) but suffers no additional effect from the cantrip.

#### Empowered Evocation

Beginning at 10th level, you can add your Intelligence modifier to one damage roll of any wizard evocation spell you cast.

#### Overchannel

Starting at 14th level, you can increase the power of your simpler spells. When you cast a wizard spell of 1st through 5th level that deals damage, you can deal maximum damage with that spell.

The first time you do so, you suffer no adverse effect. If you use this feature again before you finish a long rest, you take 2d12 necrotic damage for each level of the spell, immediately after you cast it. Each time you use this feature again before finishing a long rest, the necrotic damage per spell level increases by 1d12. This damage ignores resistance and immunity.

**Your Spellbook**

The spells that you add to your spellbook as you gain levels reflect the arcane research you conduct on your own, as well as intellectual breakthroughs you have had about the nature of the multiverse. You might find other spells during your adventures. You could discover a spell recorded on a scroll in an evil wizard's chest, for example, or in a dusty tome in an ancient library.

***Copying a Spell into the Book***. When you find a wizard spell of 1st level or higher, you can add it to your spellbook if it is of a spell level you can prepare and if you can spare the time to decipher and copy it.

Copying that spell into your spellbook involves reproducing the basic form of the spell, then deciphering the unique system of notation used by the wizard who wrote it. You must practice the spell until you understand the sounds or gestures required, then transcribe it into your spellbook using your own notation.

For each level of the spell, the process takes 2 hours and costs 50 gp. The cost represents material components you expend as you experiment with the spell to master it, as well as the fine inks you need to record it. Once you have spent this time and money, you can prepare the spell just like your other spells.

***Replacing the Book***. You can copy a spell from your own spellbook into another book-for example, if you want to make a backup copy of your spellbook. This is just like copying a new spell into your spellbook, but faster and easier, since you understand your own notation and already know how to cast the spell. You need spend only 1 hour and 10 gp for each level of the copied spell.

*If you lose your spellbook, you can use the same procedure to transcribe the spells that you have prepared into a new spellbook. Filling out the remainder of your spellbook requires you to find new spells to do so, as normal. For this reason, many wizards keep backup spellbooks in a safe place.

***The Book's Appearance***. Your spellbook is a unique compilation of spells, with its own decorative flourishes and margin notes. It might be a plain, functional leather volume that you received as a gift from your master, a finely bound gilt-edged tome you found in an ancient library, or even a loose collection of notes scrounged together after you lost your previous spellbook in a mishap.
